/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.codec;

import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import org.bdware.irp3.Opcode;
import org.bdware.irp3.ResponseCode;
import org.bdware.irp3.codec.IrpMessage;
import org.bdware.irp3.codec.Message;
import org.bdware.irp3.codec.MessageEnvelope;
import org.bdware.irp3.codec.MessageHeader;

public abstract class MessageBody
implements Message {
    private int requestId;
    private ResponseCode responseCode = ResponseCode.RC_ERRORGeneral;
    public ByteBuf toRead;
    private InetSocketAddress sender;

    public abstract void toByteBuf(ByteBuf var1);

    public abstract Opcode getOpcode();

    public IrpMessage wrapHeader() {
        IrpMessage message = new IrpMessage();
        message.envelope = MessageEnvelope.defaultEnvelop();
        message.envelope.requestId = this.requestId;
        message.header = new MessageHeader();
        message.header.opCode = this.getOpcode().code;
        message.header.responseCode = this.getResponseCode().code;
        message.header.opFlag = 0;
        message.header.siteInfoAndRecursionCount = 0;
        message.header.expirationTime = 0;
        message.body = this;
        message.credential = null;
        message.setSender(this.getSender());
        return message;
    }

    public ResponseCode getResponseCode() {
        return this.responseCode;
    }

    public MessageBody setResponseCode(ResponseCode responseCode) {
        this.responseCode = responseCode;
        return this;
    }

    public MessageBody setRequestID(int requestId) {
        this.requestId = requestId;
        return this;
    }

    public int getRequestID() {
        return this.requestId;
    }

    public void setSender(InetSocketAddress sender) {
        this.sender = sender;
    }

    public InetSocketAddress getSender() {
        return this.sender;
    }
}

