/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.codec.predefined;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.bdware.irp3.codec.Element;
import org.bdware.irp3.codec.UTF8String;

public class HS_Serv
extends Element {
    public static String TYPE = "HS_SERV";
    private String serviceIdentifier;

    public HS_Serv(Element element) {
        super(element);
        if (element != null && !element.getType().equals(TYPE)) {
            throw new IllegalArgumentException("Invalid type: " + element.getType() + ", expected: " + TYPE);
        }
    }

    public HS_Serv() {
        this.setType(TYPE);
    }

    public HS_Serv(String serviceIdentifier) {
        this.setType(TYPE);
        this.setServIdentifier(serviceIdentifier);
    }

    public void validate() {
        if (this.serviceIdentifier == null || this.serviceIdentifier.isEmpty()) {
            throw new RuntimeException("service identifier cannot be empty");
        }
    }

    public void setServIdentifier(String identifier) {
        this.serviceIdentifier = identifier;
        if (identifier != null) {
            this.setValue(identifier.getBytes(StandardCharsets.UTF_8));
        }
    }

    public String getServIdentifier() {
        return this.serviceIdentifier;
    }

    @Override
    public void fillFieldsFromValue() {
        if (this.getValue() == null || this.getValue().length == 0) {
            throw new RuntimeException("value is null or empty");
        }
        ByteBuf toRead = Unpooled.wrappedBuffer((byte[])this.getValue());
        this.serviceIdentifier = UTF8String.fromByteBuf(toRead);
        this.validate();
    }

    @Override
    public byte[] calculateValue() {
        this.validate();
        if (this.serviceIdentifier == null) {
            throw new RuntimeException("service identifier is null");
        }
        ByteBuf toWrite = Unpooled.buffer();
        UTF8String.toByteBuf(this.serviceIdentifier, toWrite);
        byte[] result = new byte[toWrite.readableBytes()];
        toWrite.readBytes(result);
        toWrite.release();
        return result;
    }

    public static class Prefix
    extends HS_Serv {
        public static String PREFIX_TYPE = "HS_SERV.PREFIX";
        private String serviceIdentifier;

        public Prefix(Element element) {
            super(element);
            if (element != null && !element.getType().equals(PREFIX_TYPE)) {
                throw new IllegalArgumentException("Invalid type: " + element.getType() + ", expected: " + PREFIX_TYPE);
            }
            this.setType(PREFIX_TYPE);
        }

        public Prefix() {
            this.setType(PREFIX_TYPE);
        }

        @Override
        public void fillFieldsFromValue() {
            if (this.getValue() == null || this.getValue().length == 0) {
                throw new RuntimeException("value is null or empty");
            }
            ByteBuf toRead = Unpooled.wrappedBuffer((byte[])this.getValue());
            this.serviceIdentifier = UTF8String.fromByteBuf(toRead);
            this.validate();
        }

        @Override
        public byte[] calculateValue() {
            this.validate();
            if (this.serviceIdentifier == null) {
                throw new RuntimeException("service identifier is null");
            }
            ByteBuf toWrite = Unpooled.buffer();
            UTF8String.toByteBuf(this.serviceIdentifier, toWrite);
            byte[] result = new byte[toWrite.readableBytes()];
            toWrite.readBytes(result);
            toWrite.release();
            return result;
        }
    }
}

