package org.bdware.irp3.body;

import io.netty.buffer.ByteBuf;
import org.bdware.irp3.codec.MessageBody;
import org.bdware.irp3.codec.RequestDigest;

public class ChallengeResponseResponse extends MessageBody {
    RequestDigest requestDigest;
    byte verificationResult;

    public static ChallengeResponseResponse fromByteBuf(ByteBuf byteBuf) {
        ChallengeResponseResponse request = new ChallengeResponseResponse();
        request.requestDigest = RequestDigest.fromByteBuf(byteBuf);
        request.verificationResult = byteBuf.readByte();
        return request;
    }

    @Override
    public void toByteBuf(ByteBuf byteBuf) {
        requestDigest.toByteBuf(byteBuf);
        byteBuf.writeByte(verificationResult);
        return;
    }
}
