package org.bdware.irp3.body;

import io.netty.buffer.ByteBuf;
import org.bdware.irp3.codec.MessageBody;
import org.bdware.irp3.codec.RequestDigest;

public class ClientAuthResponse extends MessageBody {
    RequestDigest requestDigest;
    int nonce;

    public static ClientAuthResponse fromByteBuf(ByteBuf byteBuf) {
        ClientAuthResponse response = new ClientAuthResponse();
        response.requestDigest = RequestDigest.fromByteBuf(byteBuf);
        response.nonce = byteBuf.readInt();
        return response;
    }

    @Override
    public void toByteBuf(ByteBuf byteBuf) {
        requestDigest.toByteBuf(byteBuf);
        byteBuf.writeInt(nonce);
    }
}
