package org.bdware.irp3.body;

import io.netty.buffer.ByteBuf;
import org.bdware.irp3.codec.MessageBody;
import org.bdware.irp3.codec.RequestDigest;
import org.bdware.irp3.codec.UTF8String;

public class CreateIdentifierResponse extends MessageBody {
    RequestDigest requestDigest;
    String identifier;

    public static CreateIdentifierResponse fromByteBuf(ByteBuf byteBuf) {
        CreateIdentifierResponse request = new CreateIdentifierResponse();
        request.requestDigest = RequestDigest.fromByteBuf(byteBuf);
        request.identifier = UTF8String.fromByteBuf(byteBuf);
        return request;
    }

    @Override
    public void toByteBuf(ByteBuf byteBuf) {
        requestDigest.toByteBuf(byteBuf);
        UTF8String.toByteBuf(identifier, byteBuf);
    }
}
