package org.bdware.irp3.body;

import io.netty.buffer.ByteBuf;
import org.bdware.irp3.codec.MessageBody;
import org.bdware.irp3.codec.UTF8String;

public class GetSiteInfoRequest extends MessageBody {
    String ignoredIdentifier;

    public static GetSiteInfoRequest fromByteBuf(ByteBuf byteBuf) {
        GetSiteInfoRequest request = new GetSiteInfoRequest();
        request.ignoredIdentifier = UTF8String.fromByteBuf(byteBuf);
        return request;
    }

    @Override
    public void toByteBuf(ByteBuf byteBuf) {
        UTF8String.toByteBuf(ignoredIdentifier, byteBuf);
        return;
    }
}
