package org.bdware.irp3.body;

import io.netty.buffer.ByteBuf;
import org.bdware.irp3.codec.Element;
import org.bdware.irp3.codec.MessageBody;
import org.bdware.irp3.codec.predefined.HS_Site;

public class GetSiteInfoResponse extends MessageBody {
    HS_Site siteInfo;

    public static GetSiteInfoResponse fromByteBuf(ByteBuf byteBuf) {
        GetSiteInfoResponse request = new GetSiteInfoResponse();
        HS_Site siteInfo = HS_Site.parse(Element.fromByteBuf(byteBuf));
        return request;
    }

    @Override
    public void toByteBuf(ByteBuf byteBuf) {
        siteInfo.toByteBuf(byteBuf);
        return;
    }
}
