package org.bdware.irp3.body;

import io.netty.buffer.ByteBuf;
import org.bdware.irp3.codec.MessageBody;
import org.bdware.irp3.codec.UTF8String;

public class ListDerivedPrefixsRequest extends MessageBody {
    String prefixIdentifier;

    public static ListDerivedPrefixsRequest fromByteBuf(ByteBuf byteBuf) {
        ListDerivedPrefixsRequest request = new ListDerivedPrefixsRequest();
        request.prefixIdentifier = UTF8String.fromByteBuf(byteBuf);
        return request;
    }

    @Override
    public void toByteBuf(ByteBuf byteBuf) {
        UTF8String.toByteBuf(prefixIdentifier, byteBuf);
    }
}
