package org.bdware.irp3.body;

import io.netty.buffer.ByteBuf;
import org.bdware.irp3.codec.Element;
import org.bdware.irp3.codec.IntegerList;
import org.bdware.irp3.codec.MessageBody;
import org.bdware.irp3.codec.UTF8String;

public class RemoveElementRequest extends MessageBody {
    String identifier;
    int[] elements;

    public static RemoveElementRequest fromByteBuf(ByteBuf byteBuf) {
        RemoveElementRequest request = new RemoveElementRequest();
        request.identifier = UTF8String.fromByteBuf(byteBuf);
        request.elements = IntegerList.fromByteBuf(byteBuf);
        return request;
    }

    @Override
    public void toByteBuf(ByteBuf byteBuf) {
        UTF8String.toByteBuf(identifier, byteBuf);
        IntegerList.toByteBuf(elements, byteBuf);
    }
}
