package org.bdware.irp3.body;

import io.netty.buffer.ByteBuf;
import org.bdware.irp3.codec.ByteList;
import org.bdware.irp3.codec.MessageBody;
import org.bdware.irp3.codec.RequestDigest;

public class SessionSetupResponse extends MessageBody {
    RequestDigest requestDigest;
    short mode;

    byte[] data;

    public static SessionSetupResponse fromByteBuf(ByteBuf byteBuf) {
        SessionSetupResponse request = new SessionSetupResponse();
        request.requestDigest = RequestDigest.fromByteBuf(byteBuf);
        request.mode = byteBuf.readShort();
        request.data = ByteList.fromByteBuf(byteBuf);
        return request;
    }

    @Override
    public void toByteBuf(ByteBuf byteBuf) {
        requestDigest.toByteBuf(byteBuf);
        byteBuf.writeShort(mode);
        ByteList.toByteBuf(data, byteBuf);
        return;
    }
}
