package org.bdware.irp3.body;

import io.netty.buffer.ByteBuf;
import org.bdware.irp3.codec.MessageBody;
import org.bdware.irp3.codec.RequestDigest;

public class VerificationResponse extends MessageBody {
    RequestDigest requestDigest;
    int nonce;

    public static VerificationResponse fromByteBuf(ByteBuf byteBuf) {
        VerificationResponse response = new VerificationResponse();
        response.requestDigest = RequestDigest.fromByteBuf(byteBuf);
        response.nonce = byteBuf.readInt();
        return response;
    }

    @Override
    public void toByteBuf(ByteBuf byteBuf) {
        requestDigest.toByteBuf(byteBuf);
        byteBuf.writeInt(nonce);
    }
}
