package org.bdware.irp3.client;

import org.bdware.irp3.IrpMessageFactory;
import org.bdware.irp3.body.QueryRequest;
import org.bdware.irp3.body.QueryResponse;
import org.bdware.irp3.codec.IrpMessage;
import org.bdware.irp3.codec.ResponseParser;

import java.net.URISyntaxException;

public class TcpClient {
    TcpClientChannel channel;

    public TcpClient(String targetUrl) throws URISyntaxException {
        channel = new TcpClientChannel();
        channel.connect(targetUrl);
    }

    public QueryResponse query(String identifier, int[] indexList, String[] typeList) {
        QueryRequest request = new QueryRequest(identifier, indexList, typeList);
        IrpMessage response = channel.sendMessageSync(IrpMessageFactory.createQuery(request));
        QueryResponse queryResponse = (QueryResponse) ResponseParser.parse(response);
        return queryResponse;
    }
}
