package org.bdware.irp3.codec;

import io.netty.buffer.ByteBuf;

public class Element {
    int index;
    String type;
    byte[] value;
    byte permission;
    byte ttlType;
    int ttl;
    int timestamp;
    static final int references = 0;

    public Element() {
    }

    public Element(Element element) {
        this.index = element.index;
        this.type = element.type;
        this.value = element.value;
        this.permission = element.permission;
        this.ttlType = element.ttlType;
        this.ttl = element.ttl;
        this.timestamp = element.timestamp;
    }

    public static Element[] listFromByteBuf(ByteBuf byteBuf) {
        int len = byteBuf.readInt();
        if (len <= 0) len = 0;
        Element[] ret = new Element[len];
        for (int i = 0; i < len; i++)
            ret[i] = Element.fromByteBuf(byteBuf);
        return ret;
    }

    public static void toByteBuf(Element[] elements, ByteBuf byteBuf) {
        if (elements == null || elements.length == 0)
            byteBuf.writeInt(0);
        for (int i = 0; i < elements.length; i++)
            elements[i].toByteBuf(byteBuf);
        return;
    }


    public static Element fromByteBuf(ByteBuf byteBuf) {
        Element element = new Element();
        element.index = byteBuf.readInt();
        element.type = UTF8String.fromByteBuf(byteBuf);
        element.value = ByteList.fromByteBuf(byteBuf);
        element.permission = byteBuf.readByte();
        element.ttlType = byteBuf.readByte();
        element.ttl = byteBuf.readInt();
        element.timestamp = byteBuf.readInt();
        //consume the deprecated references
        byteBuf.readInt();
        return element;
    }

    public void toByteBuf(ByteBuf byteBuf) {
        byteBuf.writeInt(index);
        UTF8String.toByteBuf(type, byteBuf);
        ByteList.toByteBuf(value, byteBuf);
        byteBuf.writeByte(permission);
        byteBuf.writeByte(ttlType);
        byteBuf.writeInt(ttl);
        byteBuf.writeInt(timestamp);
        // add deprecated references
        byteBuf.writeInt(0);
    }
}
