package org.bdware.irp3.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;

import java.util.List;

public class IrpMessageCodec extends MessageToMessageCodec<ByteBuf, IrpMessage> {
    //new LengthFieldBasedFrameDecoder(IrpCommon.MAX_MESSAGE_PACKET_LENGTH, 16, 4, 0, 0)
    @Override
    protected void encode(ChannelHandlerContext ctx, IrpMessage msg, List<Object> out) throws Exception {
        ByteBuf buff = Unpooled.directBuffer();
        msg.toByteBuf(buff);
        out.add(buff);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        out.add(IrpMessage.fromByteBuf(msg));
        return;
    }
}
