package org.bdware.irp3.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import org.bdware.irp3.Opcode;
import org.bdware.irp3.body.*;

import java.util.List;

public class ResponseCodec extends MessageToMessageCodec<IrpMessage, MessageBody> {
    @Override
    protected void encode(ChannelHandlerContext ctx, MessageBody msg, List<Object> out) throws Exception {
        //encode response and request uses the same method
        out.add(msg.wrapHeader());
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, IrpMessage msg, List<Object> out) throws Exception {
        try {
            // decode request
            MessageHeader header = msg.header;
            Opcode opcode = Opcode.fromInt(header.opCode);
            ByteBuf byteBuf = msg.body.toRead;
            if (opcode == null) out.add(UnknownBody.fromByteBuf(byteBuf));
            switch (opcode) {
                case OC_RESOLUTION:
                    out.add(QueryResponse.fromByteBuf(byteBuf));
                    return;
                case OC_GET_SITE_INFO:
                    out.add(GetSiteInfoResponse.fromByteBuf(byteBuf));
                    return;
                case OC_CREATE_ID:
                    out.add(CreateIdentifierResponse.fromByteBuf(byteBuf));
                    return;
                case OC_DELETE_ID:
                    out.add(RawBody.fromByteBuf(byteBuf));
                    return;
                case OC_ADD_ELEMENT:
                    out.add(RawBody.fromByteBuf(byteBuf));
                    return;
                case OC_REMOVE_ELEMENT:
                    out.add(RawBody.fromByteBuf(byteBuf));
                    return;
                case OC_MODIFY_ELEMENT:
                    out.add(RawBody.fromByteBuf(byteBuf));
                    return;
                case OC_LIST_IDS:
                    out.add(ListIdentifiersResponse.fromByteBuf(byteBuf));
                    return;
                case OC_LIST_DERIVED_PREFIXES:
                    out.add(ListDerivedPrefixsResponse.fromByteBuf(byteBuf));
                    return;
                case OC_LIST_HOMED_PREFIXES:
                    out.add(ListHomedPrefixResponse.fromByteBuf(byteBuf));
                    return;
                case OC_CHALLENGE_RESPONSE:
                    //challenge response is sent from client to server
                    //challenge reponse from client to server is !VerificationRequest!
                    out.add(ChallengeResponseResponse.fromByteBuf(byteBuf));
                    return;
                case OC_VERIFY_RESPONSE:
                    //verify response is sent from key manager server.
                    //@TODO ack?
                    out.add(VerificationResponse.fromByteBuf(byteBuf));
                    return;
                case OC_HOME_PREFIX:
                    out.add(RawBody.fromByteBuf(byteBuf));
                    return;
                case OC_UNHOME_PREFIX:
                    out.add(RawBody.fromByteBuf(byteBuf));
                    return;
                case OC_SESSION_SETUP:
                    out.add(SessionSetupResponse.fromByteBuf(byteBuf));
                    return;
                case OC_SESSION_TERMINATE:
                    out.add(SessionTerminationRequest.fromByteBuf(byteBuf));
                    return;
                case OC_RESERVED:
                default:
                    out.add(UnknownBody.fromByteBuf(byteBuf));
                    return;
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (msg != null && msg.body != null && msg.body.toRead != null) msg.body.toRead.release();
        }
    }
}
