package org.bdware.irp3.codec.predefined;

import io.netty.buffer.ByteBuf;
import org.bdware.irp3.codec.ByteList;

public class ServerRecord {
    int serverID;
    byte[] address;
    byte[] publicKeyRecord;
    ServiceInterface[] serviceInterfaces;

    //publicKey=  keytype(string), 2byte reserved,
    public static ServerRecord fromByteBuf(ByteBuf byteBuf) {
        ServerRecord record = new ServerRecord();
        record.serverID = byteBuf.readInt();
        record.address = ByteList.fromByteBuf(byteBuf);
        record.publicKeyRecord = ByteList.fromByteBuf(byteBuf);
        record.serviceInterfaces = ServiceInterface.listFromByteBuf(byteBuf);
        return record;
    }
}
