package org.bdware.irp3.codec.predefined;

import io.netty.buffer.ByteBuf;

public class ServiceInterface {
    byte serviceType;
    byte transportProtocol;
    int portNumber;

    public static ServiceInterface[] listFromByteBuf(ByteBuf buf) {
        int len = buf.readInt();
        if (len < 0) len = 0;
        ServiceInterface[] ret = new ServiceInterface[len];
        for (int i = 0; i < len; i++) {
            ret[i] = fromByteBuf(buf);
        }
        return ret;
    }

    public static ServiceInterface fromByteBuf(ByteBuf buf) {
        ServiceInterface ret = new ServiceInterface();
        ret.serviceType = buf.readByte();
        ret.transportProtocol = buf.readByte();
        ret.portNumber = buf.readInt();
        return ret;
    }

    public void toByteBuf(ByteBuf buf) {
        buf.writeByte(serviceType);
        buf.writeByte(transportProtocol);
        buf.writeInt(portNumber);
    }
}
