package org.bdware.irp3.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.*;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp3.codec.IrpMessageCodec;

public class TcpListener {
    static Logger LOGGER = LogManager.getLogger(TcpListener.class);
    public int port;
    private Channel ch;
    public RequestHandler requestHandler;

    public void start() {
        MessageHandler messageHandler = new MessageHandler(requestHandler);
        EventLoopGroup bossGroup = new NioEventLoopGroup(1);
        EventLoopGroup workerGroup = new NioEventLoopGroup();
        int maxFrame = 5 * 1024 * 1024;
        try {
            ServerBootstrap b = new ServerBootstrap();
            b.option(ChannelOption.WRITE_BUFFER_WATER_MARK,
                    new WriteBufferWaterMark(2 * maxFrame, 10 * maxFrame));
            b.group(bossGroup, workerGroup)
                    .channel(NioServerSocketChannel.class)
                    .localAddress(port);
            b.childHandler(
                    new ChannelInitializer<SocketChannel>() {
                        @Override
                        protected void initChannel(SocketChannel ch) throws Exception {
                            ch.pipeline()
                                    .addLast(new LengthFieldBasedFrameDecoder(maxFrame, 16, 4, 0, 0)
                                    )
                                    .addLast(new IrpMessageCodec())
                                    //   .addLast()
                                    .addLast(messageHandler);
                        }
                    });
            ch = b.bind().syncUninterruptibly().channel();
            LOGGER.info("TCP IRP listener start at:" + port);
            ch.closeFuture().sync();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            bossGroup.shutdownGracefully();
        }
    }

    public void stop() {
        ch.close();
    }
}
