/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nimbusds.jose.jwk.JWK;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp.client.IRPConfig;
import org.bdware.irp.client.IrpClient;
import org.bdware.irp.client.IrsClient;
import org.bdware.irp.deprecated.JWKSigner;
import org.bdware.irp.exception.IrpClientException;
import org.bdware.irp.irpclient.IrpClientChannel;
import org.bdware.irp.irpclient.IrpClientChannelGenerator;
import org.bdware.irp.irpclient.IrpMessageCallback;
import org.bdware.irp.irplib.core.HandleRequest;
import org.bdware.irp.irplib.core.HandleResponse;
import org.bdware.irp.irplib.core.IrpMessage;
import org.bdware.irp.irplib.core.IrpMessageSigner;
import org.bdware.irp.irplib.core.IrpRequest;
import org.bdware.irp.irplib.core.IrpRequestFactory;
import org.bdware.irp.irplib.core.IrpResponse;
import org.bdware.irp.irplib.exception.IrpConnectException;
import org.bdware.irp.stateinfo.StateInfoBase;

public class IrpClientImpl
implements IrpClient,
IrsClient {
    static Logger LOGGER = LogManager.getLogger(IrpClientImpl.class);
    IrpClientChannel irpChannel;
    String serverURL = null;
    String clientID;
    IrpRequestFactory factory;
    String address = null;

    public IrpClientImpl(JWK jwk, String clientID, String LHSUrl) {
        this.clientID = clientID;
        this.serverURL = LHSUrl;
        this.factory = new IrpRequestFactory(new JWKSigner(jwk));
    }

    public IrpClientImpl(String clientID, String LHSUrl, IrpMessageSigner signer) {
        this.clientID = clientID;
        this.serverURL = LHSUrl;
        this.factory = new IrpRequestFactory(signer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolveHandle(String handle) throws IrpClientException {
        HandleRequest req = HandleRequest.newResolveHandleRequest(handle, null, null);
        ResponseCallback rcb = new ResponseCallback();
        this.sendMessage(req, rcb);
        ResponseCallback responseCallback = rcb;
        synchronized (responseCallback) {
            try {
                rcb.wait(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        HandleResponse res = (HandleResponse)rcb.response;
        JsonArray values = JsonParser.parseString((String)res.getHandleValuesAsJson()).getAsJsonArray();
        JsonObject result = new JsonObject();
        result.addProperty("handle", res.getHandle());
        result.add("values", (JsonElement)values);
        return result.toString();
    }

    public IrpResponse sendMessageSync(IrpMessage irpMessage) {
        return this.sendMessageSync(irpMessage, IRPConfig.IRPClientDefaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IrpResponse sendMessageSync(IrpMessage irpMessage, long timeout) {
        ResponseCallback rcb = new ResponseCallback();
        this.sendMessage(irpMessage, rcb);
        ResponseCallback responseCallback = rcb;
        synchronized (responseCallback) {
            try {
                rcb.wait(timeout);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (rcb.response == null) {
            rcb.response = IrpResponse.newErrorResponse(0, 2, "Server response timeout!");
        }
        return rcb.response;
    }

    @Override
    public StateInfoBase resolve(String doid) throws IrpClientException {
        IrpRequest req = this.factory.newIrsResolveRequest(doid, null);
        IrpResponse res = this.sendMessageSync(req);
        LOGGER.info(res.toString());
        if (res.result == "success") {
            String values = new Gson().toJson(res.getDoidValuesByMap());
            JsonObject resp = JsonParser.parseString((String)values).getAsJsonObject();
            StateInfoBase hr = new StateInfoBase();
            if (resp == null) {
                throw new IrpClientException("resolve failed!");
            }
            hr.identifier = res.getDoid();
            hr.handleValues = resp;
            return hr;
        }
        return null;
    }

    public StateInfoBase resolveRecursive(String doid) throws IrpClientException {
        IrpRequest req = this.factory.newIrsResolveRecursiveRequest(doid, null);
        IrpResponse res = this.sendMessageSync(req);
        LOGGER.info(res.toString());
        if (res.result == "success") {
            String values = new Gson().toJson(res.getDoidValuesByMap());
            JsonObject resp = JsonParser.parseString((String)values).getAsJsonObject();
            StateInfoBase hr = new StateInfoBase();
            if (resp == null) {
                throw new IrpClientException("resolve failed!");
            }
            hr.identifier = res.getDoid();
            hr.handleValues = resp;
            return hr;
        }
        return null;
    }

    @Override
    public String register(StateInfoBase hr) throws IrpClientException {
        HashMap<String, String> map = this.hrToMap(hr);
        map.remove("identifier");
        IrpRequest req = this.factory.newIrsCreateDoidRequest(map);
        IrpResponse res = this.sendMessageSync(req);
        if (res.result != "success") {
            LOGGER.error("Register doid failed: " + res.getResponseMessage());
            throw new IrpClientException(res.getResponseMessage());
        }
        return res.getDoid();
    }

    @Override
    public String reRegister(StateInfoBase hr) throws IrpClientException {
        if (hr.identifier == null) {
            LOGGER.warn("handle need to be set.");
        }
        HashMap<String, String> map = this.hrToMap(hr);
        IrpRequest req = this.factory.newIrsUpdateDoidRequest(hr.identifier, map);
        IrpResponse res = this.sendMessageSync(req);
        if (res.result != "success") {
            LOGGER.error("Reregister doid failed: " + res.getResponseMessage());
            throw new IrpClientException(res.getResponseMessage());
        }
        return res.getDoid();
    }

    @Override
    public String unRegister(String handle) {
        if (handle == null) {
            LOGGER.warn("handle need to be set.");
        }
        IrpRequest req = this.factory.newIrsDeleteDoidRequest(handle);
        IrpResponse res = this.sendMessageSync(req);
        if (res.result != "success") {
            LOGGER.error("Delete doid failed: " + res.getResponseMessage());
        }
        return res.result;
    }

    @Override
    public List<String> batchRegister(StateInfoBase hr, int count) throws IrpClientException {
        HashMap<String, String> map = this.hrToMap(hr);
        map.remove("identifier");
        IrpRequest req = this.factory.newIrsBatchCreateDoidRequest(map, count);
        IrpResponse res = this.sendMessageSync(req);
        if (res.result != "success") {
            LOGGER.error("Register doid failed: " + res.getResponseMessage());
            throw new IrpClientException("register failed!");
        }
        return res.getDoidList();
    }

    @Override
    public boolean verifyIrsServer() {
        if (this.clientID == null) {
            LOGGER.warn("pre_doid need to be set in the jwk sk string to verify the irs server!");
            return false;
        }
        IrpRequest req = this.factory.newVerityIrsServerRequest(this.clientID, this.address);
        IrpResponse res = this.sendMessageSync(req);
        if (res.result != "success") {
            LOGGER.error("Verify the IRS Server from GRS failed: " + res.getResponseMessage());
            return false;
        }
        return true;
    }

    @Override
    public StateInfoBase resolvePrefix(String doid) throws IrpClientException {
        IrpRequest req = this.factory.newGrsResolveRequest(doid, null);
        IrpResponse res = this.sendMessageSync(req);
        LOGGER.info(res.toString());
        if (res.result == "success") {
            String values = new Gson().toJson(res.getDoidValuesByMap());
            JsonObject resp = JsonParser.parseString((String)values).getAsJsonObject();
            StateInfoBase hr = new StateInfoBase();
            if (resp == null) {
                throw new IrpClientException("resolve failed!");
            }
            hr.identifier = res.getDoid();
            hr.handleValues = resp;
            return hr;
        }
        return null;
    }

    @Override
    public boolean syncPrefixToGrs(StateInfoBase stateInfoBase) throws IrpClientException {
        LOGGER.info(new Gson().toJson((Object)stateInfoBase));
        IrpRequest req = this.factory.newGrsCreateOrgRequest(stateInfoBase.getIdentifier(), this.hrToMap(stateInfoBase));
        IrpResponse res = this.sendMessageSync(req);
        LOGGER.info(res.toString());
        return res.result == "success";
    }

    @Override
    public boolean synPrefixToParent(StateInfoBase stateInfoBase) throws IrpClientException {
        LOGGER.info(new Gson().toJson((Object)stateInfoBase));
        IrpRequest req = this.factory.newIrsSynOrgToParentRequest(stateInfoBase.getIdentifier(), this.hrToMap(stateInfoBase));
        IrpResponse res = this.sendMessageSync(req);
        LOGGER.info(res.toString());
        return res.result == "success";
    }

    public void setAddress(String address) {
        this.address = address;
    }

    private HashMap<String, String> hrToMap(StateInfoBase handleRecord) {
        String className;
        HashMap<String, String> hrMap = new HashMap<String, String>();
        for (String keys : handleRecord.handleValues.keySet()) {
            LOGGER.info(keys);
            if (handleRecord.handleValues.get(keys) == null || handleRecord.handleValues.get(keys).isJsonNull()) continue;
            hrMap.put(keys, handleRecord.handleValues.get(keys).getAsString());
        }
        switch (className = handleRecord.getClass().getSimpleName()) {
            case "DoStateInfo": {
                hrMap.put("hrType", "do");
                break;
            }
            case "DoipServiceStateInfo": {
                hrMap.put("hrType", "org/bdware/doip");
                break;
            }
            case "UserStateInfo": {
                hrMap.put("hrType", "dou");
                break;
            }
            default: {
                LOGGER.error("use specific handle record class instead.");
            }
        }
        return hrMap;
    }

    @Override
    public void close() {
        this.irpChannel.close();
        this.irpChannel = null;
    }

    @Override
    public void connect(String url) {
        try {
            this.irpChannel = IrpClientChannelGenerator.createIrpClientChannel(url);
            if (this.irpChannel == null) {
                return;
            }
            this.irpChannel.connect(url);
            this.serverURL = url;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void connect(String clientID, String LHSUrl, IrpMessageSigner signer) {
        this.connect(LHSUrl);
    }

    @Override
    public void reconnect() throws IrpConnectException {
        if (this.serverURL == null) {
            throw new IrpConnectException("target URL not set, use .connect(url) first");
        }
        if (this.irpChannel == null) {
            this.irpChannel = IrpClientChannelGenerator.createIrpClientChannel(this.serverURL);
        }
        if (this.irpChannel == null) {
            return;
        }
        try {
            this.irpChannel.connect(this.serverURL);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isConnected() {
        return this.irpChannel != null && this.irpChannel.isConnected();
    }

    public void sendMessage(IrpMessage msg, IrpMessageCallback cb) {
        if (this.irpChannel == null || !this.irpChannel.isConnected()) {
            LOGGER.warn("channel not connect yet!");
            this.connect(this.serverURL);
            return;
        }
        this.irpChannel.sendMessage(msg, cb);
    }

    static class ResponseContainer {
        IrpResponse response;

        ResponseContainer() {
        }
    }

    static class ResponseCallback
    implements IrpMessageCallback {
        IrpResponse response = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void onResult(IrpMessage msg) {
            LOGGER.info("<callback>message header: " + msg.header.opCode);
            this.response = (IrpResponse)msg;
            ResponseCallback responseCallback = this;
            synchronized (responseCallback) {
                this.notifyAll();
            }
        }
    }
}

