/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irpserver;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.incubator.codec.quic.QuicServerCodecBuilder;
import io.netty.incubator.codec.quic.QuicSslContext;
import io.netty.incubator.codec.quic.QuicSslContextBuilder;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp.irplib.crypto.NettyTCPCodeC;
import org.bdware.irp.irpserver.IrpListener;
import org.bdware.irp.irpserver.IrpListenerInfo;
import org.bdware.irp.irpserver.IrpRequestHandler;
import org.bdware.irp.irpserver.NettyServerHandler;

public class NettyIrpQuicListener
implements IrpListener {
    static Logger logger = LogManager.getLogger(NettyIrpQuicListener.class);
    NettyServerHandler handler;
    private Channel ch;
    private final int port;
    IrpListenerInfo info;

    protected NettyIrpQuicListener(IrpListenerInfo listenerInfo) {
        this.info = listenerInfo;
        this.port = listenerInfo.port;
    }

    public static NettyIrpQuicListener CreateIrpListener(IrpListenerInfo listenerInfo) {
        return new NettyIrpQuicListener(listenerInfo);
    }

    @Override
    public void setRequestHandler(IrpRequestHandler handler) {
        this.handler = new NettyServerHandler(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.handler == null) {
            logger.error("Handler not init yet! set handler first");
            return;
        }
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = this.info.workerGroupThreadSize <= 0 ? new NioEventLoopGroup() : new NioEventLoopGroup(this.info.workerGroupThreadSize);
        try {
            SelfSignedCertificate selfSignedCertificate = new SelfSignedCertificate();
            Bootstrap b = new Bootstrap();
            QuicSslContext context = QuicSslContextBuilder.forServer((File)selfSignedCertificate.privateKey(), null, (File)selfSignedCertificate.certificate()).applicationProtocols(new String[]{"irp/3.0"}).build();
            ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)workerGroup)).channel(NioDatagramChannel.class)).localAddress(this.port);
            ChannelHandler codec = ((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)new QuicServerCodecBuilder().sslContext(context)).maxIdleTimeout(5000L, TimeUnit.MILLISECONDS)).initialMaxData(10000000L)).initialMaxStreamDataBidirectionalLocal(1000000L)).initialMaxStreamDataBidirectionalRemote(1000000L)).initialMaxStreamsBidirectional(100L)).initialMaxStreamsUnidirectional(100L)).handler((ChannelHandler)new LengthFieldBasedFrameDecoder(262144, 16, 4, 0, 0)).handler((ChannelHandler)new NettyTCPCodeC()).handler((ChannelHandler)this.handler).build();
            b.handler(codec);
            this.ch = b.bind().syncUninterruptibly().channel();
            logger.info("UDP IRP listener start at:" + this.port);
            this.ch.closeFuture().sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    @Override
    public void stop() {
        if (this.ch != null) {
            this.ch.close();
        }
    }
}

