/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.body;

import io.netty.buffer.ByteBuf;
import org.bdware.irp3.codec.ByteList;
import org.bdware.irp3.codec.MessageBody;
import org.bdware.irp3.codec.UTF8String;

public class SessionSetupRequest
extends MessageBody {
    short mode;
    int timeout;
    String identityIdentifier;
    int identityIndex;
    byte[] publicKey;

    public static SessionSetupRequest fromByteBuf(ByteBuf byteBuf) {
        SessionSetupRequest request = new SessionSetupRequest();
        request.mode = byteBuf.readShort();
        request.timeout = byteBuf.readInt();
        request.identityIdentifier = UTF8String.fromByteBuf(byteBuf);
        request.identityIndex = byteBuf.readInt();
        request.publicKey = ByteList.fromByteBuf(byteBuf);
        return request;
    }

    @Override
    public void toByteBuf(ByteBuf byteBuf) {
        byteBuf.writeShort((int)this.mode);
        byteBuf.writeInt(this.timeout);
        UTF8String.toByteBuf(this.identityIdentifier, byteBuf);
        byteBuf.writeInt(this.identityIndex);
        ByteList.toByteBuf(this.publicKey, byteBuf);
    }
}

