/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.body;

import io.netty.buffer.ByteBuf;
import org.bdware.irp3.codec.ByteList;
import org.bdware.irp3.codec.MessageBody;
import org.bdware.irp3.codec.RequestDigest;
import org.bdware.irp3.codec.UTF8String;

public class VerificationRequest
extends MessageBody {
    String keyIdentifier;
    int keyIndex;
    int nonce;
    RequestDigest serverChallengeReqDigest;
    byte[] challengeResponse;

    public static VerificationRequest fromByteBuf(ByteBuf byteBuf) {
        VerificationRequest request = new VerificationRequest();
        request.keyIdentifier = UTF8String.fromByteBuf(byteBuf);
        request.keyIndex = byteBuf.readInt();
        request.challengeResponse = ByteList.fromByteBuf(byteBuf);
        request.serverChallengeReqDigest = RequestDigest.fromByteBuf(byteBuf);
        return request;
    }

    @Override
    public void toByteBuf(ByteBuf byteBuf) {
        UTF8String.toByteBuf(this.keyIdentifier, byteBuf);
        byteBuf.writeInt(this.keyIndex);
        byteBuf.writeBytes(this.challengeResponse);
        this.serverChallengeReqDigest.toByteBuf(byteBuf);
    }
}

