/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp3.client.IrpTimeoutCreator;
import org.bdware.irp3.client.ResponseWait;
import org.bdware.irp3.client.ResultCallback;
import org.bdware.irp3.codec.IrpMessage;

public class ClientHandler
extends SimpleChannelInboundHandler<IrpMessage> {
    public Channel channel;
    static Logger LOGGER = LogManager.getLogger(ClientHandler.class);
    ResponseWait<IrpMessage> sync = new ResponseWait<IrpMessage>(new IrpTimeoutCreator());
    Random random = new Random();

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void sendMessage(IrpMessage request, ResultCallback<IrpMessage> callback, int timeoutInSeconds) {
        if (callback == null) {
            LOGGER.error("ResultCallback is null, please check!");
        }
        if (request.envelope.getRequestID() == 0) {
            request.envelope.setRequestID(this.random.nextInt());
            while (!this.sync.waitResponse(request.envelope.getRequestID(), callback, timeoutInSeconds)) {
                request.envelope.setRequestID(this.random.nextInt());
            }
        } else if (!this.sync.waitResponse(request.envelope.getRequestID(), callback, timeoutInSeconds)) {
            LOGGER.debug("duplicate requestID, please check");
        }
        this.channel.writeAndFlush((Object)request);
        LOGGER.info("Send:" + request.prettyPrint());
    }

    protected void channelRead0(ChannelHandlerContext ctx, IrpMessage msg) throws Exception {
        LOGGER.info("Recv:" + msg.prettyPrint());
        this.sync.wakeUpAndRemove(msg.envelope.getRequestID(), msg);
    }
}

