/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp3.client.ClientHandler;
import org.bdware.irp3.client.ResultCallback;
import org.bdware.irp3.codec.IrpMessage;
import org.bdware.irp3.codec.IrpMessageCodec;

public class TcpClientChannel {
    final Bootstrap b = new Bootstrap();
    static EventLoopGroup group = new NioEventLoopGroup();
    private final ClientHandler handler;
    static Logger LOGGER = LogManager.getLogger(TcpClientChannel.class);
    private static final int DefaultTimeout = 5;

    public TcpClientChannel() {
        this.b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000);
        this.b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.b.group(group);
        this.handler = new ClientHandler();
        ((Bootstrap)((Bootstrap)this.b.channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(262144, 16, 4, 0, 0)}).addLast(new ChannelHandler[]{new IrpMessageCodec()}).addLast(new ChannelHandler[]{TcpClientChannel.this.handler});
            }
        });
    }

    public void sendMessage(IrpMessage message, ResultCallback<IrpMessage> cb) {
        this.handler.sendMessage(message, cb, 5);
    }

    public IrpMessage sendMessageSync(IrpMessage msg) {
        return this.sendMessageSync(msg, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IrpMessage sendMessageSync(IrpMessage msg, int timeoutInSeconds) {
        SyncCallback rcb = new SyncCallback();
        this.handler.sendMessage(msg, rcb, timeoutInSeconds);
        SyncCallback syncCallback = rcb;
        synchronized (syncCallback) {
            try {
                rcb.wait(timeoutInSeconds * 1100);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (rcb.response == null) {
            return null;
        }
        return rcb.response;
    }

    public void connect(String targetUrl) throws URISyntaxException {
        URI uri = new URI(targetUrl);
        LOGGER.info("[URI Parse]scheme:" + uri.getScheme() + "  host: " + uri.getHost() + "  port: " + uri.getPort());
        try {
            Channel channel = this.b.connect(uri.getHost(), uri.getPort()).sync().channel();
            this.handler.setChannel(channel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class SyncCallback
    implements ResultCallback<IrpMessage> {
        private IrpMessage response;

        SyncCallback() {
        }

        @Override
        public synchronized void onResult(IrpMessage message) {
            this.response = message;
            this.notifyAll();
        }
    }
}

