/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.codec;

import io.netty.buffer.ByteBuf;
import org.bdware.irp3.codec.ByteList;
import org.bdware.irp3.codec.UTF8String;

public class Element {
    int index;
    String type;
    byte[] value;
    byte permission;
    byte ttlType;
    int ttl;
    int timestamp;
    static final int references = 0;

    public Element() {
    }

    public Element(Element element) {
        this.index = element.index;
        this.type = element.type;
        this.value = element.value;
        this.permission = element.permission;
        this.ttlType = element.ttlType;
        this.ttl = element.ttl;
        this.timestamp = element.timestamp;
    }

    public static Element[] listFromByteBuf(ByteBuf byteBuf) {
        int len = byteBuf.readInt();
        if (len <= 0) {
            len = 0;
        }
        Element[] ret = new Element[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = Element.fromByteBuf(byteBuf);
        }
        return ret;
    }

    public static void toByteBuf(Element[] elements, ByteBuf byteBuf) {
        if (elements == null || elements.length == 0) {
            byteBuf.writeInt(0);
        }
        for (int i = 0; i < elements.length; ++i) {
            elements[i].toByteBuf(byteBuf);
        }
    }

    public static Element fromByteBuf(ByteBuf byteBuf) {
        Element element = new Element();
        element.index = byteBuf.readInt();
        element.type = UTF8String.fromByteBuf(byteBuf);
        element.value = ByteList.fromByteBuf(byteBuf);
        element.permission = byteBuf.readByte();
        element.ttlType = byteBuf.readByte();
        element.ttl = byteBuf.readInt();
        element.timestamp = byteBuf.readInt();
        byteBuf.readInt();
        return element;
    }

    public void toByteBuf(ByteBuf byteBuf) {
        byteBuf.writeInt(this.index);
        UTF8String.toByteBuf(this.type, byteBuf);
        ByteList.toByteBuf(this.value, byteBuf);
        byteBuf.writeByte((int)this.permission);
        byteBuf.writeByte((int)this.ttlType);
        byteBuf.writeInt(this.ttl);
        byteBuf.writeInt(this.timestamp);
        byteBuf.writeInt(0);
    }
}

