/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.codec;

import io.netty.buffer.ByteBuf;

public class RequestDigest {
    byte digestAlgorithmIdentifier;
    byte[] messageDigest;

    public static RequestDigest fromByteBuf(ByteBuf buf) {
        RequestDigest requestDigest = new RequestDigest();
        requestDigest.digestAlgorithmIdentifier = buf.readByte();
        switch (requestDigest.digestAlgorithmIdentifier) {
            case 1: {
                requestDigest.messageDigest = new byte[16];
                break;
            }
            case 2: {
                requestDigest.messageDigest = new byte[20];
                break;
            }
            case 3: {
                requestDigest.messageDigest = new byte[32];
                break;
            }
            default: {
                requestDigest.messageDigest = null;
            }
        }
        if (requestDigest.messageDigest != null) {
            buf.readBytes(requestDigest.messageDigest);
        }
        return requestDigest;
    }

    public void toByteBuf(ByteBuf byteBuf) {
        byteBuf.writeByte((int)this.digestAlgorithmIdentifier);
        switch (this.digestAlgorithmIdentifier) {
            case 1: 
            case 2: 
            case 3: {
                byteBuf.writeBytes(this.messageDigest);
                break;
            }
        }
    }
}

