/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.codec;

import io.netty.buffer.ByteBuf;
import org.bdware.irp3.Opcode;
import org.bdware.irp3.body.AddElementRequest;
import org.bdware.irp3.body.ChallengeResponseRequest;
import org.bdware.irp3.body.CreateIdentifierRequest;
import org.bdware.irp3.body.DeleteIdentifierRequest;
import org.bdware.irp3.body.GetSiteInfoRequest;
import org.bdware.irp3.body.HomePrefixRequest;
import org.bdware.irp3.body.ListDerivedPrefixsRequest;
import org.bdware.irp3.body.ListHomedPrefixRequest;
import org.bdware.irp3.body.ListIdentifiersRequest;
import org.bdware.irp3.body.ModifyElementRequest;
import org.bdware.irp3.body.QueryRequest;
import org.bdware.irp3.body.RemoveElementRequest;
import org.bdware.irp3.body.SessionSetupRequest;
import org.bdware.irp3.body.SessionTerminationRequest;
import org.bdware.irp3.body.UnhomePrefixRequest;
import org.bdware.irp3.body.UnknownBody;
import org.bdware.irp3.body.VerificationResponse;
import org.bdware.irp3.codec.IrpMessage;
import org.bdware.irp3.codec.MessageBody;
import org.bdware.irp3.codec.MessageHeader;

public class ResponseParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageBody parse(IrpMessage msg) {
        try {
            MessageHeader header = msg.header;
            Opcode opcode = Opcode.fromInt(header.opCode);
            ByteBuf byteBuf = msg.body.toRead;
            if (opcode == null) {
                UnknownBody unknownBody = UnknownBody.fromByteBuf(byteBuf);
                return unknownBody;
            }
            switch (opcode) {
                case OC_RESOLUTION: {
                    QueryRequest queryRequest = QueryRequest.fromByteBuf(byteBuf);
                    return queryRequest;
                }
                case OC_GET_SITE_INFO: {
                    GetSiteInfoRequest getSiteInfoRequest = GetSiteInfoRequest.fromByteBuf(byteBuf);
                    return getSiteInfoRequest;
                }
                case OC_CREATE_ID: {
                    CreateIdentifierRequest createIdentifierRequest = CreateIdentifierRequest.fromByteBuf(byteBuf);
                    return createIdentifierRequest;
                }
                case OC_DELETE_ID: {
                    DeleteIdentifierRequest deleteIdentifierRequest = DeleteIdentifierRequest.fromByteBuf(byteBuf);
                    return deleteIdentifierRequest;
                }
                case OC_ADD_ELEMENT: {
                    AddElementRequest addElementRequest = AddElementRequest.fromByteBuf(byteBuf);
                    return addElementRequest;
                }
                case OC_REMOVE_ELEMENT: {
                    RemoveElementRequest removeElementRequest = RemoveElementRequest.fromByteBuf(byteBuf);
                    return removeElementRequest;
                }
                case OC_MODIFY_ELEMENT: {
                    ModifyElementRequest modifyElementRequest = ModifyElementRequest.fromByteBuf(byteBuf);
                    return modifyElementRequest;
                }
                case OC_LIST_IDS: {
                    ListIdentifiersRequest listIdentifiersRequest = ListIdentifiersRequest.fromByteBuf(byteBuf);
                    return listIdentifiersRequest;
                }
                case OC_LIST_DERIVED_PREFIXES: {
                    ListDerivedPrefixsRequest listDerivedPrefixsRequest = ListDerivedPrefixsRequest.fromByteBuf(byteBuf);
                    return listDerivedPrefixsRequest;
                }
                case OC_LIST_HOMED_PREFIXES: {
                    ListHomedPrefixRequest listHomedPrefixRequest = ListHomedPrefixRequest.fromByteBuf(byteBuf);
                    return listHomedPrefixRequest;
                }
                case OC_CHALLENGE_RESPONSE: {
                    ChallengeResponseRequest challengeResponseRequest = ChallengeResponseRequest.fromByteBuf(byteBuf);
                    return challengeResponseRequest;
                }
                case OC_VERIFY_RESPONSE: {
                    VerificationResponse verificationResponse = VerificationResponse.fromByteBuf(byteBuf);
                    return verificationResponse;
                }
                case OC_HOME_PREFIX: {
                    HomePrefixRequest homePrefixRequest = HomePrefixRequest.fromByteBuf(byteBuf);
                    return homePrefixRequest;
                }
                case OC_UNHOME_PREFIX: {
                    UnhomePrefixRequest unhomePrefixRequest = UnhomePrefixRequest.fromByteBuf(byteBuf);
                    return unhomePrefixRequest;
                }
                case OC_SESSION_SETUP: {
                    SessionSetupRequest sessionSetupRequest = SessionSetupRequest.fromByteBuf(byteBuf);
                    return sessionSetupRequest;
                }
                case OC_SESSION_TERMINATE: {
                    SessionTerminationRequest sessionTerminationRequest = SessionTerminationRequest.fromByteBuf(byteBuf);
                    return sessionTerminationRequest;
                }
            }
            UnknownBody unknownBody = UnknownBody.fromByteBuf(byteBuf);
            return unknownBody;
        }
        catch (Exception e) {
            e.printStackTrace();
            UnknownBody unknownBody = UnknownBody.fromByteBuf(msg.body.toRead);
            return unknownBody;
        }
        finally {
            if (msg != null && msg.body != null && msg.body.toRead != null) {
                msg.body.toRead.release();
            }
        }
    }
}

