/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.handler;

import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp3.body.ErrorResponse;
import org.bdware.irp3.codec.MessageBody;
import org.bdware.irp3.handler.IrpHandlerBase;
import org.bdware.irp3.handler.IrpProcessor;
import org.bdware.irp3.server.RequestHandler;

public abstract class ReflectiveRequestHandler
implements RequestHandler {
    static Logger logger = LogManager.getLogger(ReflectiveRequestHandler.class);
    Map<Class, Pair> handlerMap = new ConcurrentHashMap<Class, Pair>();
    static Logger LOGGER = LogManager.getLogger(ReflectiveRequestHandler.class);
    List<IrpHandlerBase> handlers = new ArrayList<IrpHandlerBase>();

    public void addHandler(IrpHandlerBase handler) {
        Class<?> handlerClass = handler.getClass();
        while (!handlerClass.equals(Object.class)) {
            Class<?>[] interfaces;
            this.putHandlerMethod(handler, handlerClass);
            for (Class<?> clz : interfaces = handlerClass.getInterfaces()) {
                this.putHandlerMethod(handler, handlerClass);
            }
            handlerClass = handlerClass.getSuperclass();
        }
    }

    private void putHandlerMethod(IrpHandlerBase handler, Class handlerClass) {
        Method[] methods;
        for (Method m : methods = handlerClass.getDeclaredMethods()) {
            IrpProcessor a = m.getAnnotation(IrpProcessor.class);
            if (a == null) continue;
            Class<?>[] parameters = m.getParameterTypes();
            if (!(parameters.length == 2 || parameters[0].equals(ChannelHandlerContext.class) && MessageBody.class.isAssignableFrom(parameters[1]))) {
                LOGGER.error("IrpProcessor parameter error:" + handlerClass.getCanonicalName() + ":" + m.getName());
                continue;
            }
            if (!m.getReturnType().equals(Void.TYPE) && !MessageBody.class.isAssignableFrom(m.getReturnType())) {
                LOGGER.error("IrpProcessor return type error:" + handlerClass.getCanonicalName() + ":" + m.getName());
                continue;
            }
            this.putHandler(handler, parameters[1], m);
        }
    }

    private void putHandler(IrpHandlerBase handler, Class<?> parameter, Method m) {
        m.setAccessible(true);
        Pair p = new Pair();
        p.obj = handler;
        p.method = m;
        this.handlerMap.put(parameter, p);
    }

    @Override
    public MessageBody onRequest(ChannelHandlerContext ctx, MessageBody msg) {
        Pair pair = this.handlerMap.get(msg.getClass());
        if (pair != null) {
            try {
                return (MessageBody)pair.method.invoke((Object)pair.obj, ctx, msg);
            }
            catch (Exception e) {
                e.printStackTrace();
                return new ErrorResponse(e.getMessage());
            }
        }
        return new ErrorResponse("unsupported type:" + msg.getClass().getCanonicalName());
    }

    static class Pair {
        IrpHandlerBase obj;
        Method method;

        Pair() {
        }
    }
}

