/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp3.codec.IrpMessageCodec;
import org.bdware.irp3.server.MessageHandler;
import org.bdware.irp3.server.RequestHandler;

public class TcpListener {
    static Logger LOGGER = LogManager.getLogger(TcpListener.class);
    public int port;
    private Channel ch;
    public RequestHandler requestHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        final MessageHandler messageHandler = new MessageHandler(this.requestHandler);
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        final int maxFrame = 0x500000;
        try {
            ServerBootstrap b = new ServerBootstrap();
            b.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(2 * maxFrame, 10 * maxFrame));
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).localAddress(this.port);
            b.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(maxFrame, 16, 4, 0, 0)}).addLast(new ChannelHandler[]{new IrpMessageCodec()}).addLast(new ChannelHandler[]{messageHandler});
                }
            });
            this.ch = b.bind().syncUninterruptibly().channel();
            LOGGER.info("TCP IRP listener start at:" + this.port);
            this.ch.closeFuture().sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            bossGroup.shutdownGracefully();
        }
    }

    public void stop() {
        this.ch.close();
    }
}

