package org.bdware.irp.stateinfo;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class StateInfoBase {
    public String identifier;
    public JsonObject handleValues;
    static final String UUID_KEY = "UUID";
    static final String TIMESTAMP = "__timestamp__";
    //@liuyi TODO need to verify if the ttl is second or millisecond
    public static final String TTL = "__ttl__";

    public static String ADMIN = "HS_ADMIN";

    public StateInfoBase() {
        handleValues = new JsonObject();
        //handleValues.add(ADMIN, new JsonObject());
    }


    public StateInfoBase(JsonObject handleValues) {
        if (handleValues == null)
            this.handleValues = new JsonObject();
        else
            this.handleValues = handleValues;
    }

    public StateInfoBase(String identifier, JsonObject handleValues) {
        this.identifier = identifier;
        if (handleValues == null)
            this.handleValues = new JsonObject();
        else
            this.handleValues = handleValues;
    }


    public UUID getUUID() {
        return UUID.fromString(getValues(UUID_KEY));
    }

    public void setUUID(UUID uuid) {
        this.handleValues.addProperty(UUID_KEY, uuid.toString());
    }

    public static StateInfoBase fromJson(String json) {
        return new Gson().fromJson(json, StateInfoBase.class);
    }

    public String getIdentifier() {
        return identifier;
    }

    public JsonObject getHandleValues() {
        return handleValues;
    }

    public void setHandleValues(JsonObject handleValues) {
        this.handleValues = handleValues;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getValues(String key) {
        return handleValues.has(key) ? handleValues.get(key).getAsString() : null;
    }


    public JsonObject getAdmins(){
        return handleValues.has(ADMIN) ? handleValues.get(ADMIN).getAsJsonObject() : null;
    }

    public short getAdmin(String doi){
        JsonObject admins = getAdmins();
        return admins.has(doi) ? admins.get(doi).getAsShort() : 0;
    }

    public void setAdmin(String doi, short permission){
        JsonObject admins = getAdmins();
        admins.addProperty(doi, permission);
    }

    public void setTimestamp(long timestamp) {
        this.handleValues.addProperty(TIMESTAMP, timestamp);
    }
    public void setTTL(long ttl) {
        this.handleValues.addProperty(TTL, ttl);
    }

    public long getTimestamp() {
        if(this.handleValues.get(TIMESTAMP) == null){
            return -1;
        }
        return this.handleValues.get(TIMESTAMP).getAsLong();
    }

    public long getTTL() {
        if(this.handleValues.get(TTL) == null){
            return -1;
        }
        return this.handleValues.get(TTL).getAsLong();
    }

    public boolean cacheValidate(){
        long ttl = getTTL();
        if(ttl < 0)
            return false;
        long now = System.currentTimeMillis();
        return ttl > now ? true : false;

    }


    public Map<String, String> getHandleValuesAsMap() {
        Map<String, String>
                ret = new HashMap<>();
        if (handleValues != null) for (String key : handleValues.keySet())
            ret.put(key, handleValues.get(key).getAsString());
        return ret;
    }
}
