/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irpclient;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp.irpclient.IrpMessageCallback;
import org.bdware.irp.irpclient.ResponseWait;
import org.bdware.irp.irplib.core.IrpMessage;

@ChannelHandler.Sharable
public class NettyIrpClientHandler
extends SimpleChannelInboundHandler<IrpMessage> {
    static Logger logger = LogManager.getLogger(NettyIrpClientHandler.class);
    public Channel channel;
    ResponseWait sync = new ResponseWait();
    Random random = new Random();

    public void sendMessage(IrpMessage request, IrpMessageCallback callback) {
        if (callback == null) {
            logger.error("DoMessageCallback is null, please check!");
        }
        if (request.envelope.requestId == 0) {
            request.envelope.requestId = this.random.nextInt();
            while (!this.sync.waitResponse(request.envelope.requestId, callback)) {
                request.envelope.requestId = this.random.nextInt();
            }
        } else if (!this.sync.waitResponse(request.envelope.requestId, callback)) {
            logger.debug("duplicate requestID, please check");
        }
        this.channel.writeAndFlush((Object)request);
    }

    public void close() {
        this.channel.close();
    }

    public void setChannel(Channel c) {
        this.channel = c;
    }

    protected void channelRead0(ChannelHandlerContext ctx, IrpMessage msg) {
        this.sync.wakeUpAndRemove(msg.envelope.requestId, msg);
    }
}

