/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irpserver;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp.irpserver.IrpHandler;
import org.bdware.irp.irpserver.IrpListener;
import org.bdware.irp.irpserver.IrpListenerInfo;
import org.bdware.irp.irpserver.IrpRequestHandlerImpl;
import org.bdware.irp.irpserver.IrpServer;
import org.bdware.irp.irpserver.IrpServerInfo;
import org.bdware.irp.irpserver.NettyIrpListener;

public class IrpServerImpl
implements IrpServer {
    static Logger logger = LogManager.getLogger(IrpServerImpl.class);
    List<IrpListener> listeners;
    IrpServerInfo serverInfo;
    List<ListenerContainer> containers;
    protected IrpRequestHandlerImpl requestCallback;

    public IrpServerImpl(IrpServerInfo info) {
        this.serverInfo = info;
        this.requestCallback = new IrpRequestHandlerImpl();
        this.listeners = new ArrayList<IrpListener>();
        for (IrpListenerInfo listenerInfo : info.listenerInfos) {
            IrpListener listener = NettyIrpListener.CreateIrpListener(listenerInfo);
            this.listeners.add(listener);
        }
        this.containers = new ArrayList<ListenerContainer>();
    }

    public static IrpServer createIrpServer(IrpServerInfo info) {
        return new IrpServerImpl(info);
    }

    @Override
    public void start() {
        logger.info("IRPServerInfo: " + this.serverInfo.toJson());
        for (IrpListener listener : this.listeners) {
            listener.setRequestHandler(this.requestCallback);
            ListenerContainer container = new ListenerContainer(listener);
            this.containers.add(container);
            container.start();
        }
    }

    @Override
    public void stop() {
        logger.info("Try to stop listeners:");
        for (IrpListener listener : this.listeners) {
            listener.stop();
        }
        for (ListenerContainer c : this.containers) {
            c.interrupt();
        }
    }

    @Override
    public void setIrpServerHandler(IrpHandler handler) {
        this.requestCallback.setIrpHandler(handler);
    }

    public class ListenerContainer
    extends Thread {
        IrpListener listener;

        ListenerContainer(IrpListener l) {
            this.listener = l;
        }

        @Override
        public void run() {
            this.listener.start();
        }
    }
}

