/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.stateinfo;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class StateInfoBase {
    public String identifier;
    public JsonObject handleValues;
    static final String UUID_KEY = "UUID";
    static final String TIMESTAMP = "__timestamp__";
    public static final String TTL = "__ttl__";
    public static String ADMIN = "HS_ADMIN";

    public StateInfoBase() {
        this.handleValues = new JsonObject();
    }

    public StateInfoBase(JsonObject handleValues) {
        this.handleValues = handleValues == null ? new JsonObject() : handleValues;
    }

    public StateInfoBase(String identifier, JsonObject handleValues) {
        this.identifier = identifier;
        this.handleValues = handleValues == null ? new JsonObject() : handleValues;
    }

    public UUID getUUID() {
        return UUID.fromString(this.getValues(UUID_KEY));
    }

    public void setUUID(UUID uuid) {
        this.handleValues.addProperty(UUID_KEY, uuid.toString());
    }

    public static StateInfoBase fromJson(String json) {
        return (StateInfoBase)new Gson().fromJson(json, StateInfoBase.class);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public JsonObject getHandleValues() {
        return this.handleValues;
    }

    public void setHandleValues(JsonObject handleValues) {
        this.handleValues = handleValues;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getValues(String key) {
        return this.handleValues.has(key) ? this.handleValues.get(key).getAsString() : null;
    }

    public JsonObject getAdmins() {
        return this.handleValues.has(ADMIN) ? this.handleValues.get(ADMIN).getAsJsonObject() : null;
    }

    public short getAdmin(String doi) {
        JsonObject admins = this.getAdmins();
        return admins.has(doi) ? admins.get(doi).getAsShort() : (short)0;
    }

    public void setAdmin(String doi, short permission) {
        JsonObject admins = this.getAdmins();
        admins.addProperty(doi, (Number)permission);
    }

    public void setTimestamp(long timestamp) {
        this.handleValues.addProperty(TIMESTAMP, (Number)timestamp);
    }

    public void setTTL(long ttl) {
        this.handleValues.addProperty(TTL, (Number)ttl);
    }

    public long getTimestamp() {
        if (this.handleValues.get(TIMESTAMP) == null) {
            return -1L;
        }
        return this.handleValues.get(TIMESTAMP).getAsLong();
    }

    public long getTTL() {
        if (this.handleValues.get(TTL) == null) {
            return -1L;
        }
        return this.handleValues.get(TTL).getAsLong();
    }

    public boolean cacheValidate() {
        long ttl = this.getTTL();
        if (ttl < 0L) {
            return false;
        }
        long now = System.currentTimeMillis();
        return ttl > now;
    }

    public Map<String, String> getHandleValuesAsMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (this.handleValues != null) {
            for (String key : this.handleValues.keySet()) {
                ret.put(key, this.handleValues.get(key).getAsString());
            }
        }
        return ret;
    }
}

