/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.codec;

import io.netty.buffer.ByteBuf;
import org.bdware.irp3.codec.ByteList;
import org.bdware.irp3.codec.UTF8String;

public class SignedInfo {
    int length;
    String digestAlgorithm;
    int signedDataLength;
    byte[] signedData;

    public static SignedInfo fromByteBuf(ByteBuf byteBuf) {
        SignedInfo info = new SignedInfo();
        info.length = byteBuf.readInt();
        info.digestAlgorithm = UTF8String.fromByteBuf(byteBuf);
        info.signedDataLength = byteBuf.readInt();
        info.signedData = new byte[info.signedDataLength];
        byteBuf.readBytes(info.signedData);
        return info;
    }

    public void toByteBuf(ByteBuf byteBuf) {
        byteBuf.writeInt(this.length);
        this.length = UTF8String.length(this.digestAlgorithm) + ByteList.length(this.signedData);
        UTF8String.toByteBuf(this.digestAlgorithm, byteBuf);
        ByteList.toByteBuf(this.signedData, byteBuf);
    }
}

