/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.server;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import java.io.File;
import javax.net.ssl.SSLEngine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp.irpserver.IrpListenerInfo;
import org.bdware.irp3.codec.DatagramPacketToIrpMessageCodec;
import org.bdware.irp3.codec.IrpMessageCodec;
import org.bdware.irp3.codec.RequestCodec;
import org.bdware.irp3.codec.WebSocketFrameToByteBufCodec;
import org.bdware.irp3.server.BootstrapInitializer;
import org.bdware.irp3.server.MessageHandler;
import org.bdware.irp3.server.tls.TLSListenerInfo;

public class BootstrapInitializerFactory {
    static Logger LOGGER = LogManager.getLogger(BootstrapInitializerFactory.class);

    public static BootstrapInitializer<? extends AbstractBootstrap> createServerBootstrapInitializer(IrpListenerInfo listenerInfo) {
        switch (listenerInfo.protocolType.toLowerCase()) {
            case "tcp": {
                return new TcpInitializer(listenerInfo);
            }
            case "udp": {
                return new UdpInitializer(listenerInfo);
            }
            case "tls": {
                return new TLSInitializer((TLSListenerInfo)listenerInfo);
            }
            case "ws": {
                return new WSInitializer(listenerInfo);
            }
        }
        return null;
    }

    static class WSInitializer
    implements BootstrapInitializer<ServerBootstrap> {
        IrpListenerInfo info;

        public WSInitializer(IrpListenerInfo listenerInfo) {
            this.info = listenerInfo;
        }

        @Override
        public ServerBootstrap init(final MessageHandler handler) {
            ServerBootstrap b = new ServerBootstrap();
            NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
            NioEventLoopGroup workerGroup = new NioEventLoopGroup();
            final int maxFrame = 0x500000;
            b.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(2 * maxFrame, 10 * maxFrame));
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).localAddress(this.info.port);
            b.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(maxFrame)}).addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler("/WS", null, true)}).addLast(new ChannelHandler[]{new WebSocketFrameToByteBufCodec()}).addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(maxFrame, 16, 4, 0, 0)}).addLast(new ChannelHandler[]{new IrpMessageCodec()}).addLast(new ChannelHandler[]{new RequestCodec()}).addLast(new ChannelHandler[]{handler});
                }
            });
            LOGGER.info("WS Listen at " + this.info.port);
            return b;
        }
    }

    static class TLSInitializer
    implements BootstrapInitializer<ServerBootstrap> {
        private final SslContext sslContext;
        TLSListenerInfo info;

        public TLSInitializer(TLSListenerInfo listenerInfo) {
            this.info = listenerInfo;
            this.sslContext = this.getSSLContext(listenerInfo.getChainKeyFile(), listenerInfo.getKeyFile());
        }

        protected SslContext getSSLContext(File chainFile, File keyFile) throws IllegalStateException {
            try {
                SslContext sslContext = SslContextBuilder.forServer((File)chainFile, (File)keyFile).ciphers(null, (ciphers, defaultCiphers, supportedCiphers) -> (String[])defaultCiphers.stream().filter(x -> null != x && !x.contains("RC4")).toArray(String[]::new)).build();
                return sslContext;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public ServerBootstrap init(final MessageHandler handler) {
            ServerBootstrap b = new ServerBootstrap();
            NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
            NioEventLoopGroup workerGroup = new NioEventLoopGroup();
            final int maxFrame = 0x500000;
            b.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(2 * maxFrame, 10 * maxFrame));
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).localAddress(this.info.port);
            b.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    SSLEngine engine = sslContext.newEngine(ch.alloc());
                    engine.setUseClientMode(false);
                    engine.setNeedClientAuth(false);
                    ch.pipeline().addFirst("ssl", (ChannelHandler)new SslHandler(engine)).addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(maxFrame, 16, 4, 0, 0)}).addLast(new ChannelHandler[]{new IrpMessageCodec()}).addLast(new ChannelHandler[]{new RequestCodec()}).addLast(new ChannelHandler[]{handler});
                }
            });
            LOGGER.info("TLS Listen at " + this.info.port);
            return b;
        }
    }

    static class UdpInitializer
    implements BootstrapInitializer<Bootstrap> {
        IrpListenerInfo info;

        public UdpInitializer(IrpListenerInfo listenerInfo) {
            this.info = listenerInfo;
        }

        @Override
        public Bootstrap init(final MessageHandler handler) {
            NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
            NioEventLoopGroup workerGroup = new NioEventLoopGroup();
            Bootstrap b = new Bootstrap();
            int maxFrame = 0x500000;
            ((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)workerGroup)).channel(NioDatagramChannel.class)).localAddress(this.info.port)).option(ChannelOption.SO_BROADCAST, (Object)true);
            b.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(0, 100));
            b.handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(){

                protected void initChannel(DatagramChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new DatagramPacketToIrpMessageCodec()}).addLast(new ChannelHandler[]{new RequestCodec()}).addLast(new ChannelHandler[]{handler});
                }
            });
            LOGGER.info("UDP Listen at " + this.info.port);
            return b;
        }
    }

    static class TcpInitializer
    implements BootstrapInitializer<ServerBootstrap> {
        IrpListenerInfo info;

        public TcpInitializer(IrpListenerInfo listenerInfo) {
            this.info = listenerInfo;
        }

        @Override
        public ServerBootstrap init(final MessageHandler handler) {
            ServerBootstrap b = new ServerBootstrap();
            NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
            NioEventLoopGroup workerGroup = new NioEventLoopGroup();
            final int maxFrame = 0x500000;
            b.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(2 * maxFrame, 10 * maxFrame));
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).localAddress(this.info.port);
            b.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(maxFrame, 16, 4, 0, 0)}).addLast(new ChannelHandler[]{new IrpMessageCodec()}).addLast(new ChannelHandler[]{new RequestCodec()}).addLast(new ChannelHandler[]{handler});
                }
            });
            LOGGER.info("TCP Listen at " + this.info.port);
            return b;
        }
    }
}

