/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.server;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.channel.Channel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp3.server.BootstrapInitializer;
import org.bdware.irp3.server.MessageHandler;
import org.bdware.irp3.server.RequestHandler;

public class IrpListener {
    static Logger LOGGER = LogManager.getLogger(IrpListener.class);
    private final BootstrapInitializer<? extends AbstractBootstrap> initializer;
    private Channel ch;
    public RequestHandler requestHandler;

    public IrpListener(RequestHandler requestHandler, BootstrapInitializer<? extends AbstractBootstrap> initializer) {
        this.requestHandler = requestHandler;
        this.initializer = initializer;
    }

    public void start() {
        MessageHandler messageHandler = new MessageHandler(this.requestHandler);
        try {
            AbstractBootstrap bootstrap = this.initializer.init(messageHandler);
            this.ch = bootstrap.bind().syncUninterruptibly().channel();
            this.ch.closeFuture().sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        this.ch.close();
    }
}

