/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.stateinfo;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class StateInfoBase {
    public static final byte PUBLIC_WRITE = 1;
    public static final byte PUBLIC_READ = 2;
    public static final byte ADMIN_WRITE = 4;
    public static final byte ADMIN_READ = 8;
    public static final String ADMIN_WRITE_DOI = "ADMIN_WRITE";
    public static final String ADMIN_READ_DOI = "ADMIN_READ";
    public static final String ELEMENT_WRITE_DOI = "ELEMENT_WRITE";
    public static final String ELEMENT_READ_DOI = "ELEMENT_READ";
    public String identifier;
    public JsonObject handleValues;
    static final String UUID_KEY = "UUID";
    static final String TIMESTAMP = "__timestamp__";
    public static final String TTL = "__ttl__";
    public static final String SESSION = "__session_id__";
    public byte permission;
    public static String ADMIN = "HS_ADMIN";

    public StateInfoBase() {
        this.handleValues = new JsonObject();
        this.permission = 0;
    }

    public byte getPermission() {
        return this.permission;
    }

    public void setPermission(byte permission) {
        this.permission = permission;
    }

    public void setSessionId(String sessionId) {
        this.handleValues.addProperty(SESSION, sessionId);
    }

    public String getSessionId() {
        return this.handleValues.has(SESSION) ? this.handleValues.get(SESSION).getAsString() : null;
    }

    public StateInfoBase(JsonObject handleValues) {
        this.handleValues = handleValues == null ? new JsonObject() : handleValues;
    }

    public StateInfoBase(String identifier, JsonObject handleValues) {
        this.identifier = identifier;
        this.handleValues = handleValues == null ? new JsonObject() : handleValues;
    }

    public UUID getUUID() {
        return UUID.fromString(this.getValues(UUID_KEY));
    }

    public void setUUID(UUID uuid) {
        this.handleValues.addProperty(UUID_KEY, uuid.toString());
    }

    public static StateInfoBase fromJson(String json) {
        return (StateInfoBase)new Gson().fromJson(json, StateInfoBase.class);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public JsonObject getHandleValues() {
        return this.handleValues;
    }

    public void setHandleValues(JsonObject handleValues) {
        this.handleValues = handleValues;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getValues(String key) {
        return this.handleValues.has(key) ? this.handleValues.get(key).getAsString() : null;
    }

    public JsonObject getAdmins() {
        if (!this.handleValues.has(ADMIN)) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add(ADMIN_WRITE_DOI, (JsonElement)new JsonArray());
            jsonObject.add(ADMIN_READ_DOI, (JsonElement)new JsonArray());
            jsonObject.add(ELEMENT_WRITE_DOI, (JsonElement)new JsonArray());
            jsonObject.add(ELEMENT_READ_DOI, (JsonElement)new JsonArray());
            this.handleValues.add(ADMIN, (JsonElement)jsonObject);
        }
        return this.handleValues.get(ADMIN).getAsJsonObject();
    }

    public boolean canReadElement(String doi) {
        if ((this.permission & 2) > 0) {
            return true;
        }
        if ((this.permission & 8) == 0) {
            return false;
        }
        JsonObject admins = this.getAdmins();
        JsonArray readElements = admins.get(ELEMENT_READ_DOI).getAsJsonArray();
        if (readElements.isEmpty()) {
            return false;
        }
        for (JsonElement jsonElement : readElements) {
            if (!doi.equals(jsonElement.getAsString())) continue;
            return true;
        }
        return false;
    }

    public boolean canModifyElement(String doi) {
        if ((this.permission & 1) > 0) {
            return true;
        }
        if ((this.permission & 4) == 0) {
            return false;
        }
        JsonObject admins = this.getAdmins();
        JsonArray modifyElements = admins.get(ELEMENT_WRITE_DOI).getAsJsonArray();
        if (modifyElements.isEmpty()) {
            return false;
        }
        for (JsonElement jsonElement : modifyElements) {
            if (!doi.equals(jsonElement.getAsString())) continue;
            return true;
        }
        return false;
    }

    public boolean canModifyAdmin(String doi) {
        if ((this.permission & 1) > 0) {
            return true;
        }
        if ((this.permission & 4) == 0) {
            return false;
        }
        JsonObject admins = this.getAdmins();
        JsonArray modifyAdmins = admins.get(ADMIN_WRITE_DOI).getAsJsonArray();
        if (modifyAdmins.isEmpty()) {
            return false;
        }
        for (JsonElement jsonElement : modifyAdmins) {
            if (!doi.equals(jsonElement.getAsString())) continue;
            return true;
        }
        return false;
    }

    public JsonArray updateElement(String doi, int type, JsonArray jsonArray) {
        if (type == 0) {
            for (JsonElement jsonElement : jsonArray) {
                if (!doi.equals(jsonElement.getAsString())) continue;
                jsonArray.remove(jsonElement);
            }
        } else {
            jsonArray.add(doi);
        }
        return jsonArray;
    }

    public void setAdmin(String doi, String adminType, int type) {
        JsonObject admins = this.getAdmins();
        if (ADMIN_WRITE_DOI.equals(adminType)) {
            this.updateElement(doi, type, admins.get(ADMIN_WRITE_DOI).getAsJsonArray());
        } else if (ADMIN_READ_DOI.equals(adminType)) {
            this.updateElement(doi, type, admins.get(ADMIN_READ_DOI).getAsJsonArray());
        } else if (ELEMENT_READ_DOI.equals(adminType)) {
            this.updateElement(doi, type, admins.get(ELEMENT_READ_DOI).getAsJsonArray());
        } else if (ELEMENT_WRITE_DOI.equals(adminType)) {
            this.updateElement(doi, type, admins.get(ELEMENT_WRITE_DOI).getAsJsonArray());
        }
    }

    public void setTimestamp(long timestamp) {
        this.handleValues.addProperty(TIMESTAMP, (Number)timestamp);
    }

    public void setTTL(long ttl) {
        this.handleValues.addProperty(TTL, (Number)ttl);
    }

    public long getTimestamp() {
        if (this.handleValues.get(TIMESTAMP) == null) {
            return -1L;
        }
        return this.handleValues.get(TIMESTAMP).getAsLong();
    }

    public long getTTL() {
        if (this.handleValues.get(TTL) == null) {
            return -1L;
        }
        return this.handleValues.get(TTL).getAsLong();
    }

    public boolean cacheValidate() {
        long ttl = this.getTTL();
        if (ttl < 0L) {
            return false;
        }
        long now = System.currentTimeMillis();
        return ttl > now;
    }

    public Map<String, String> getHandleValuesAsMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (this.handleValues != null) {
            for (String key : this.handleValues.keySet()) {
                ret.put(key, this.handleValues.get(key).getAsString());
            }
        }
        return ret;
    }
}

