/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslHandler;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp3.client.ClientBootstrapInitializer;
import org.bdware.irp3.client.ClientConfig;
import org.bdware.irp3.client.ClientHandler;
import org.bdware.irp3.codec.DatagramPacketToIrpMessageCodec;
import org.bdware.irp3.codec.IrpMessageCodec;
import org.bdware.irp3.codec.ResponseCodec;
import org.bdware.irp3.codec.WebSocketFrameToByteBufCodec;

public class ClientBootstrapInitializerFactory {
    static EventLoopGroup workerGroup = new NioEventLoopGroup(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        }
    });
    static int maxFrame = 0x500000;

    public static ClientBootstrapInitializer createServerBootstrapInitializer(ClientConfig config) {
        switch (config.uri.getScheme().toLowerCase()) {
            case "udp": {
                return new UdpInitializer(config);
            }
            case "tcp": {
                return new TcpInitializer(config);
            }
            case "ws": {
                return new WSInitializer(config);
            }
            case "tls": {
                return new TLSInitializer(config);
            }
        }
        throw new IllegalStateException("unsupported protocol:" + config.uri.getScheme());
    }

    static class WSInitializer
    implements ClientBootstrapInitializer {
        ClientConfig info;

        public WSInitializer(ClientConfig listenerInfo) {
            this.info = listenerInfo;
        }

        @Override
        public void init(Bootstrap b, final ClientHandler handler) {
            b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000);
            b.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(0x100000, 0x1400000));
            b.group(workerGroup);
            ((Bootstrap)((Bootstrap)b.channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    WebSocketClientProtocolHandler wsClientHandler = new WebSocketClientProtocolHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)info.uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)new DefaultHttpHeaders()));
                    p.addLast(new ChannelHandler[]{new HttpClientCodec()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(maxFrame)}).addLast(new ChannelHandler[]{wsClientHandler}).addLast(new ChannelHandler[]{new WebSocketFrameToByteBufCodec()}).addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(maxFrame, 16, 4, 0, 0)}).addLast(new ChannelHandler[]{new IrpMessageCodec()}).addLast(new ChannelHandler[]{new ResponseCodec()}).addLast(new ChannelHandler[]{handler});
                }
            });
        }
    }

    static class TLSInitializer
    implements ClientBootstrapInitializer {
        ClientConfig info;
        static Logger LOGGER = LogManager.getLogger(TLSInitializer.class);

        public TLSInitializer(ClientConfig listenerInfo) {
            this.info = listenerInfo;
        }

        @Override
        public void init(Bootstrap b, final ClientHandler handler) {
            b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000);
            ((Bootstrap)((Bootstrap)b.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(0x100000, 0x1400000))).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_LINGER, (Object)0);
            b.group(workerGroup);
            final X509TrustManager DUMMY_TRUST_MANAGER = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                    LOGGER.debug("[TLSClientConfig] UNKNOWN CLIENT CERTIFICATE: " + chain[0].getSubjectDN());
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                    LOGGER.debug("UNKNOWN SERVER CERTIFICATE: " + chain[0].getSubjectDN());
                }
            };
            ((Bootstrap)((Bootstrap)b.channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    SSLEngine engine = null;
                    try {
                        SSLContext clientContext = SSLContext.getInstance("TLS");
                        clientContext.init(null, new TrustManager[]{DUMMY_TRUST_MANAGER}, null);
                        engine = clientContext.createSSLEngine();
                        engine.setUseClientMode(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    p.addFirst("ssl", (ChannelHandler)new SslHandler(engine)).addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(maxFrame, 16, 4, 0, 0)}).addLast(new ChannelHandler[]{new IrpMessageCodec()}).addLast(new ChannelHandler[]{new ResponseCodec()}).addLast(new ChannelHandler[]{handler});
                }
            });
        }
    }

    static class UdpInitializer
    implements ClientBootstrapInitializer {
        ClientConfig config;

        public UdpInitializer(ClientConfig listenerInfo) {
            this.config = listenerInfo;
        }

        @Override
        public void init(Bootstrap b, final ClientHandler handler) {
            b.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(10, 100));
            b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000);
            b.group(workerGroup);
            ((Bootstrap)((Bootstrap)b.channel(NioDatagramChannel.class)).option(ChannelOption.SO_BROADCAST, (Object)true)).handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(){

                protected void initChannel(DatagramChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new DatagramPacketToIrpMessageCodec(config.uri.getHost(), config.uri.getPort())}).addLast(new ChannelHandler[]{new ResponseCodec()}).addLast(new ChannelHandler[]{handler});
                }
            });
        }
    }

    static class TcpInitializer
    implements ClientBootstrapInitializer {
        ClientConfig config;

        public TcpInitializer(ClientConfig listenerInfo) {
            this.config = listenerInfo;
        }

        @Override
        public void init(Bootstrap b, final ClientHandler handler) {
            b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000);
            b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            b.group(workerGroup);
            ((Bootstrap)((Bootstrap)b.channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(maxFrame, 16, 4, 0, 0)}).addLast(new ChannelHandler[]{new IrpMessageCodec()}).addLast(new ChannelHandler[]{new ResponseCodec()}).addLast(new ChannelHandler[]{handler});
                }
            });
        }
    }
}

