/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp3.body.ClientAuthResponse;
import org.bdware.irp3.client.IrpClient;
import org.bdware.irp3.client.IrpMessageBodyTimeoutCreator;
import org.bdware.irp3.client.ResponseWait;
import org.bdware.irp3.client.ResultCallback;
import org.bdware.irp3.codec.MessageBody;

public class ClientHandler
extends SimpleChannelInboundHandler<MessageBody> {
    public Channel channel;
    static Logger LOGGER = LogManager.getLogger(ClientHandler.class);
    ResponseWait<MessageBody> sync = new ResponseWait<MessageBody>(new IrpMessageBodyTimeoutCreator());
    Random random = new Random();
    private IrpClient client;

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void sendMessage(MessageBody request, ResultCallback<MessageBody> callback, int timeoutInSeconds) {
        if (callback == null) {
            LOGGER.error("ResultCallback is null, please check!");
        }
        if (request.getRequestID() == 0) {
            request.setRequestID(this.random.nextInt());
            while (!this.sync.waitResponse(request.getRequestID(), callback, timeoutInSeconds)) {
                request.setRequestID(this.random.nextInt());
            }
        } else if (!this.sync.waitResponse(request.getRequestID(), callback, timeoutInSeconds)) {
            LOGGER.debug("duplicate requestID, please check");
        }
        this.channel.writeAndFlush((Object)request);
    }

    protected void channelRead0(ChannelHandlerContext ctx, MessageBody msg) throws Exception {
        LOGGER.info("ClientHandler Recv\uff1a" + msg.toString());
        if (msg instanceof ClientAuthResponse) {
            this.client.onChallengeRequest((ClientAuthResponse)msg);
        } else {
            this.sync.wakeUpAndRemove(msg.getRequestID(), msg);
        }
    }

    public void setClient(IrpClient irpClient) {
        this.client = irpClient;
    }
}

