/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.client;

import java.net.URISyntaxException;
import org.bdware.irp3.body.AddElementRequest;
import org.bdware.irp3.body.ChallengeResponseRequest;
import org.bdware.irp3.body.ChallengeResponseResponse;
import org.bdware.irp3.body.ClientAuthResponse;
import org.bdware.irp3.body.CreateIdentifierRequest;
import org.bdware.irp3.body.CreateIdentifierResponse;
import org.bdware.irp3.body.DeleteIdentifierRequest;
import org.bdware.irp3.body.ErrorResponse;
import org.bdware.irp3.body.GeneralMessage;
import org.bdware.irp3.body.GetSiteInfoRequest;
import org.bdware.irp3.body.GetSiteInfoResponse;
import org.bdware.irp3.body.HomePrefixRequest;
import org.bdware.irp3.body.ListDerivedPrefixsRequest;
import org.bdware.irp3.body.ListHomedPrefixRequest;
import org.bdware.irp3.body.ListHomedPrefixResponse;
import org.bdware.irp3.body.ListIdentifiersRequest;
import org.bdware.irp3.body.ListIdentifiersResponse;
import org.bdware.irp3.body.ModifyElementRequest;
import org.bdware.irp3.body.QueryRequest;
import org.bdware.irp3.body.QueryResponse;
import org.bdware.irp3.body.RemoveElementRequest;
import org.bdware.irp3.body.SessionSetupRequest;
import org.bdware.irp3.body.SessionSetupResponse;
import org.bdware.irp3.body.SessionTerminationRequest;
import org.bdware.irp3.body.UnhomePrefixRequest;
import org.bdware.irp3.body.VerificationRequest;
import org.bdware.irp3.body.VerificationResponse;
import org.bdware.irp3.client.ClientChannel;
import org.bdware.irp3.client.ClientConfig;
import org.bdware.irp3.client.IrpError;
import org.bdware.irp3.client.ResultCallback;
import org.bdware.irp3.codec.Element;
import org.bdware.irp3.codec.MessageBody;

public class IrpClient {
    ClientChannel channel;

    public IrpClient(ClientConfig config) throws URISyntaxException {
        this.channel = new ClientChannel(config);
        this.channel.connect(config.uri, this);
    }

    public QueryResponse query(String identifier, int[] indexList, String[] typeList) throws IrpError {
        QueryRequest request = new QueryRequest(identifier, indexList, typeList);
        MessageBody response = this.channel.sendMessageSync(request);
        if (response instanceof ErrorResponse) {
            throw new IrpError((ErrorResponse)response);
        }
        QueryResponse queryResponse = (QueryResponse)response;
        return queryResponse;
    }

    public GeneralMessage addElement(String identifier, Element[] elements) throws IrpError {
        AddElementRequest request = new AddElementRequest(identifier, elements);
        MessageBody response = this.channel.sendMessageSync(request);
        if (response instanceof ErrorResponse) {
            throw new IrpError((ErrorResponse)response);
        }
        GeneralMessage generalResponse = (GeneralMessage)response;
        return generalResponse;
    }

    public GeneralMessage removeElements(String identifier, int[] indexs) throws IrpError {
        RemoveElementRequest request = new RemoveElementRequest(identifier, indexs);
        MessageBody response = this.channel.sendMessageSync(request);
        if (response instanceof ErrorResponse) {
            throw new IrpError((ErrorResponse)response);
        }
        GeneralMessage generalResponse = (GeneralMessage)response;
        return generalResponse;
    }

    public GeneralMessage modifyElements(String identifier, Element[] elements) throws IrpError {
        ModifyElementRequest request = new ModifyElementRequest(identifier, elements);
        MessageBody response = this.channel.sendMessageSync(request);
        if (response instanceof ErrorResponse) {
            throw new IrpError((ErrorResponse)response);
        }
        GeneralMessage generalResponse = (GeneralMessage)response;
        return generalResponse;
    }

    public CreateIdentifierResponse createIdentifier(String identifier, Element[] elements) throws IrpError {
        CreateIdentifierRequest request = new CreateIdentifierRequest(identifier, elements);
        MessageBody response = this.channel.sendMessageSync(request);
        if (response instanceof ErrorResponse) {
            throw new IrpError((ErrorResponse)response);
        }
        CreateIdentifierResponse createIdentifierResponse = (CreateIdentifierResponse)response;
        return createIdentifierResponse;
    }

    public GeneralMessage deleteIdentifier(String identifier) throws IrpError {
        DeleteIdentifierRequest request = new DeleteIdentifierRequest(identifier);
        MessageBody response = this.channel.sendMessageSync(request);
        if (response instanceof ErrorResponse) {
            throw new IrpError((ErrorResponse)response);
        }
        GeneralMessage generalResponse = (GeneralMessage)response;
        return generalResponse;
    }

    protected void onChallengeRequest(ClientAuthResponse clientAuthResponse) {
    }

    public ChallengeResponseResponse clientAuth(ChallengeResponseRequest request) throws IrpError {
        MessageBody response = this.channel.sendMessageSync(request);
        if (response instanceof ErrorResponse) {
            throw new IrpError((ErrorResponse)response);
        }
        ChallengeResponseResponse generalResponse = (ChallengeResponseResponse)response;
        return generalResponse;
    }

    public VerificationResponse verifyRequest(VerificationRequest request) throws IrpError {
        MessageBody response = this.channel.sendMessageSync(request);
        if (response instanceof ErrorResponse) {
            throw new IrpError((ErrorResponse)response);
        }
        VerificationResponse generalResponse = (VerificationResponse)response;
        return generalResponse;
    }

    public GetSiteInfoResponse getSiteInfo(String ignoredIdentifier) throws IrpError {
        GetSiteInfoRequest request = new GetSiteInfoRequest(ignoredIdentifier);
        MessageBody response = this.channel.sendMessageSync(request);
        if (response instanceof ErrorResponse) {
            throw new IrpError((ErrorResponse)response);
        }
        GetSiteInfoResponse generalResponse = (GetSiteInfoResponse)response;
        return generalResponse;
    }

    public GeneralMessage homePrefix(String prefixIdentifiers) throws IrpError {
        HomePrefixRequest request = new HomePrefixRequest(prefixIdentifiers);
        MessageBody response = this.channel.sendMessageSync(request);
        if (response instanceof ErrorResponse) {
            throw new IrpError((ErrorResponse)response);
        }
        GeneralMessage generalResponse = (GeneralMessage)response;
        return generalResponse;
    }

    public GeneralMessage unhomePrefix(String prefixIdentifiers) throws IrpError {
        UnhomePrefixRequest request = new UnhomePrefixRequest(prefixIdentifiers);
        MessageBody response = this.channel.sendMessageSync(request);
        if (response instanceof ErrorResponse) {
            throw new IrpError((ErrorResponse)response);
        }
        GeneralMessage generalResponse = (GeneralMessage)response;
        return generalResponse;
    }

    public ListHomedPrefixResponse listHomePrefix(String ignoredIdentifier) throws IrpError {
        ListHomedPrefixRequest request = new ListHomedPrefixRequest(ignoredIdentifier);
        MessageBody response = this.channel.sendMessageSync(request);
        if (response instanceof ErrorResponse) {
            throw new IrpError((ErrorResponse)response);
        }
        ListHomedPrefixResponse generalResponse = (ListHomedPrefixResponse)response;
        return generalResponse;
    }

    public ListIdentifiersResponse listIdentifier(String prefixIdentifier) throws IrpError {
        ListIdentifiersRequest request = new ListIdentifiersRequest(prefixIdentifier);
        MessageBody response = this.channel.sendMessageSync(request);
        if (response instanceof ErrorResponse) {
            throw new IrpError((ErrorResponse)response);
        }
        ListIdentifiersResponse generalResponse = (ListIdentifiersResponse)response;
        return generalResponse;
    }

    public ListIdentifiersResponse listDerivedPrefixes(String prefixIdentifier) throws IrpError {
        ListDerivedPrefixsRequest request = new ListDerivedPrefixsRequest(prefixIdentifier);
        MessageBody response = this.channel.sendMessageSync(request);
        if (response instanceof ErrorResponse) {
            throw new IrpError((ErrorResponse)response);
        }
        ListIdentifiersResponse generalResponse = (ListIdentifiersResponse)response;
        return generalResponse;
    }

    public SessionSetupResponse setupSession(SessionSetupRequest request) throws IrpError {
        MessageBody response = this.channel.sendMessageSync(request);
        if (response instanceof ErrorResponse) {
            throw new IrpError((ErrorResponse)response);
        }
        SessionSetupResponse generalResponse = (SessionSetupResponse)response;
        return generalResponse;
    }

    public void terminateSession() {
        SessionTerminationRequest queryRequest = new SessionTerminationRequest();
        this.channel.sendMessage(queryRequest, new ResultCallback<MessageBody>(){

            @Override
            public void onResult(MessageBody message) {
            }
        });
    }
}

