/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageCodec;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp3.codec.IrpMessage;

public class DatagramPacketToIrpMessageCodec
extends MessageToMessageCodec<DatagramPacket, IrpMessage> {
    static Logger LOGGER = LogManager.getLogger(DatagramPacketToIrpMessageCodec.class);
    InetSocketAddress address = null;

    public DatagramPacketToIrpMessageCodec() {
    }

    public DatagramPacketToIrpMessageCodec(String host, int port) {
        this.address = new InetSocketAddress(host, port);
    }

    protected void encode(ChannelHandlerContext ctx, IrpMessage msg, List<Object> out) throws Exception {
        try {
            ByteBuf buf = ctx.alloc().directBuffer();
            msg.toByteBuf(buf);
            DatagramPacket packet = this.address == null ? new DatagramPacket(buf, msg.getSender()) : new DatagramPacket(buf, this.address);
            out.add(packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void decode(ChannelHandlerContext ctx, DatagramPacket msg, List<Object> out) throws Exception {
        ByteBuf buf = (ByteBuf)msg.content();
        IrpMessage irpMessage = IrpMessage.fromByteBuf(buf);
        irpMessage.setSender((InetSocketAddress)msg.sender());
        out.add(irpMessage);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOGGER.debug("got exception: " + cause.getMessage());
        cause.printStackTrace();
        if (ctx.channel().isActive()) {
            ctx.close();
        }
    }
}

