/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.codec;

import io.netty.buffer.ByteBuf;

public class MessageEnvelope {
    public static final int MAJORVERSION = 3;
    public static final int MINORVERSION = 0;
    int compoundHead;
    int sessionId;
    int requestId;
    int sequenceNumber;
    int messageLength;

    public static MessageEnvelope defaultEnvelop() {
        MessageEnvelope ret = new MessageEnvelope();
        ret.compoundHead = 0;
        ret.sessionId = 0;
        ret.requestId = 0;
        ret.sequenceNumber = 0;
        ret.messageLength = 0;
        return ret;
    }

    public int getMajorVersion() {
        return (this.compoundHead & 0xFF000000) >>> 24;
    }

    public int getMinorVersion() {
        return (this.compoundHead & 0xFF0000) >>> 16;
    }

    public int getFlag() {
        return (this.compoundHead & 0xE000) >>> 9;
    }

    public int getSuggMajorVersion() {
        return (this.compoundHead & 0x1F80) >> 7;
    }

    public int getSuggMinorVersion() {
        return this.compoundHead & 0x7F;
    }

    public static MessageEnvelope fromByteBuf(ByteBuf byteBuf) {
        MessageEnvelope ret = new MessageEnvelope();
        ret.compoundHead = byteBuf.readInt();
        ret.sessionId = byteBuf.readInt();
        ret.requestId = byteBuf.readInt();
        ret.sequenceNumber = byteBuf.readInt();
        ret.messageLength = byteBuf.readInt();
        return ret;
    }

    public void toByteBuf(ByteBuf byteBuf) {
        byteBuf.writeInt(this.compoundHead);
        byteBuf.writeInt(this.sessionId);
        byteBuf.writeInt(this.requestId);
        byteBuf.writeInt(this.sequenceNumber);
        byteBuf.writeInt(this.messageLength);
    }

    public int getRequestID() {
        return this.requestId;
    }

    public void setRequestID(int requestID) {
        this.requestId = requestID;
    }
}

