/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.codec.predefined;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import org.bdware.irp3.codec.ByteList;
import org.bdware.irp3.codec.Element;
import org.bdware.irp3.codec.UTF8String;

public class HS_Pubkey
extends Element {
    public static String TYPE = "HS_PUBKEY";
    String keyType;
    short reserved;
    byte[] publicKey;

    public HS_Pubkey(Element element) {
        super(element);
        assert (element.getType().equals(TYPE));
    }

    public HS_Pubkey() {
        this.setType(TYPE);
    }

    @Override
    public void fillFieldsFromValue() {
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.getValue());
        this.keyType = UTF8String.fromByteBuf(byteBuf);
        this.reserved = byteBuf.readShort();
        this.publicKey = ByteList.fromByteBuf(byteBuf);
    }

    @Override
    public byte[] calculateValue() {
        ByteBuf byteBuf = Unpooled.directBuffer();
        UTF8String.toByteBuf(this.keyType, byteBuf);
        byteBuf.writeShort((int)this.reserved);
        ByteList.toByteBuf(this.publicKey, byteBuf);
        return ByteBufUtil.getBytes((ByteBuf)byteBuf);
    }
}

