/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.codec.predefined;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import org.bdware.irp3.codec.ByteList;
import org.bdware.irp3.codec.Element;
import org.bdware.irp3.codec.UTF8String;

public class HS_Seckey
extends Element {
    public static String TYPE = "HS_SECKEY";
    byte[] secretKey;
    String keyType;
    short reserved;

    public HS_Seckey(Element element) {
        super(element);
        assert (element.getType().equals(TYPE));
    }

    public HS_Seckey() {
        this.setType(TYPE);
    }

    @Override
    public void fillFieldsFromValue() {
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.getValue());
        this.keyType = UTF8String.fromByteBuf(byteBuf);
        this.reserved = byteBuf.readShort();
        this.secretKey = ByteList.fromByteBuf(byteBuf);
    }

    @Override
    public byte[] calculateValue() {
        ByteBuf byteBuf = Unpooled.directBuffer();
        UTF8String.toByteBuf(this.keyType, byteBuf);
        byteBuf.writeShort((int)this.reserved);
        ByteList.toByteBuf(this.secretKey, byteBuf);
        return ByteBufUtil.getBytes((ByteBuf)byteBuf);
    }
}

