/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.handler;

import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp3.ResponseCode;
import org.bdware.irp3.body.ErrorResponse;
import org.bdware.irp3.codec.MessageBody;
import org.bdware.irp3.handler.IrpHandlerBase;
import org.bdware.irp3.handler.IrpProcessor;
import org.bdware.irp3.server.RequestHandler;

public class ReflectiveRequestHandler
implements RequestHandler {
    Map<Class, Pair> handlerMap = new ConcurrentHashMap<Class, Pair>();
    static Logger LOGGER = LogManager.getLogger(ReflectiveRequestHandler.class);
    List<IrpHandlerBase> handlers = new ArrayList<IrpHandlerBase>();

    public void printHandler() {
        if (this.handlerMap == null) {
            return;
        }
        for (Class clz : this.handlerMap.keySet()) {
            LOGGER.info("handler info: " + clz.getCanonicalName() + " ," + this.handlerMap.get((Object)clz).method.getName());
        }
    }

    public Map<Class, Pair> getHandlerMap() {
        return this.handlerMap;
    }

    public void setHandlerMap(Map<Class, Pair> handlerMap) {
        this.handlerMap = handlerMap;
    }

    public List<IrpHandlerBase> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<IrpHandlerBase> handlers) {
        this.handlers = handlers;
    }

    public void addHandler(IrpHandlerBase handler) {
        Class<?> handlerClass = handler.getClass();
        LOGGER.info("===add handler: " + handlerClass.getCanonicalName());
        while (!handlerClass.equals(Object.class)) {
            Class<?>[] interfaces;
            this.putHandlerMethod(handler, handlerClass);
            for (Class<?> clz : interfaces = handlerClass.getInterfaces()) {
                this.putHandlerMethod(handler, clz);
            }
            handlerClass = handlerClass.getSuperclass();
        }
    }

    private void putHandlerMethod(IrpHandlerBase handler, Class handlerClass) {
        Method[] methods;
        for (Method m : methods = handlerClass.getDeclaredMethods()) {
            IrpProcessor a = m.getAnnotation(IrpProcessor.class);
            if (a == null) continue;
            LOGGER.info("===add handler method: " + m.getName());
            Class<?>[] parameters = m.getParameterTypes();
            if (!(parameters.length == 2 || parameters[0].equals(ChannelHandlerContext.class) && MessageBody.class.isAssignableFrom(parameters[1]))) {
                LOGGER.error("IrpProcessor parameter error:" + handlerClass.getCanonicalName() + ":" + m.getName());
                continue;
            }
            if (!m.getReturnType().equals(Void.TYPE) && !MessageBody.class.isAssignableFrom(m.getReturnType())) {
                LOGGER.error("IrpProcessor return type error:" + handlerClass.getCanonicalName() + ":" + m.getName());
                continue;
            }
            this.putHandler(handler, parameters[1], m);
        }
    }

    private void putHandler(IrpHandlerBase handler, Class<?> parameter, Method m) {
        m.setAccessible(true);
        Pair p = new Pair();
        p.obj = handler;
        p.method = m;
        if (this.handlerMap.containsKey(parameter)) {
            LOGGER.warn("Duplicated Handler:" + parameter.getCanonicalName());
        }
        this.handlerMap.put(parameter, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageBody onRequest(ChannelHandlerContext ctx, MessageBody msg) {
        Pair pair = this.handlerMap.get(msg.getClass());
        MessageBody ret = null;
        if (pair != null) {
            try {
                MessageBody messageBody = ret = (MessageBody)pair.method.invoke((Object)pair.obj, ctx, msg);
                return messageBody;
            }
            catch (Exception e) {
                e.printStackTrace();
                MessageBody messageBody = ret = new ErrorResponse(e.getMessage()).setResponseCode(ResponseCode.RC_ERRORGeneral);
                return messageBody;
            }
            finally {
                if (ret != null) {
                    ret.setSender(msg.getSender());
                }
            }
        }
        LOGGER.info("unsupported msg type:" + msg.getClass().getCanonicalName());
        return new ErrorResponse("unsupported message:" + msg.getClass().getCanonicalName());
    }

    static class Pair {
        IrpHandlerBase obj;
        Method method;

        Pair() {
        }
    }
}

