/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irplib.core;

import com.google.gson.JsonObject;
import org.bdware.irp.irplib.core.IrpMessage;
import org.bdware.irp.irplib.exception.IrpMessageDecodeException;
import org.bdware.irp.irplib.util.EncoderUtils;

public class IrpRequest
extends IrpMessage {
    public byte[] doid;
    public byte[][] doidValues = null;
    public byte[][] requestedKeys = null;
    public byte[] address;
    public int createNumber = 0;

    public IrpRequest(int opCode, String doid) {
        super(opCode, 0);
        this.doid = EncoderUtils.encodeString(doid);
    }

    public IrpRequest(int opCode, byte[] doid) {
        super(opCode, 0);
        this.doid = doid;
    }

    public JsonObject getDoidValues() {
        JsonObject result = null;
        try {
            result = IrpRequest.fromByte2Json(this.doidValues);
        }
        catch (IrpMessageDecodeException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean isAuthNeeded() {
        if (this.header != null) {
            return this.header.getCertifiedFlag();
        }
        return false;
    }

    @Override
    public String getDoid() {
        return EncoderUtils.decodeString(this.doid);
    }

    public String getAddress() {
        return EncoderUtils.decodeString(this.address);
    }
}

