/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.codec;

import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp3.Opcode;
import org.bdware.irp3.ResponseCode;
import org.bdware.irp3.codec.Message;
import org.bdware.irp3.codec.MessageBody;
import org.bdware.irp3.codec.MessageCredential;
import org.bdware.irp3.codec.MessageEnvelope;
import org.bdware.irp3.codec.MessageHeader;
import org.bdware.irp3.codec.RawBody;

public class IrpMessage
implements Message {
    public MessageEnvelope envelope;
    public MessageHeader header;
    public MessageBody body;
    public MessageCredential credential;
    static Logger LOGGER = LogManager.getLogger(IrpMessage.class);
    private InetSocketAddress sender;

    public static IrpMessage fromByteBuf(ByteBuf msg) {
        IrpMessage message = new IrpMessage();
        message.envelope = MessageEnvelope.fromByteBuf(msg);
        message.header = MessageHeader.fromByteBuf(msg);
        int len = message.header.bodyLength;
        message.body = new RawBody();
        int readerInder = msg.readerIndex();
        message.body.toRead = msg.retainedSlice(readerInder, len);
        assert (message.body.toRead != null);
        int readerIndex = msg.readerIndex();
        if (message.header.getCertifiedFlag()) {
            msg.readerIndex(len + readerIndex);
            message.credential = MessageCredential.fromByteBuf(msg);
        }
        return message;
    }

    public void toByteBuf(ByteBuf byteBuf) {
        int beginIndex = byteBuf.writerIndex();
        this.envelope.toByteBuf(byteBuf);
        int headerIndex = byteBuf.writerIndex();
        this.header.toByteBuf(byteBuf);
        this.body.toByteBuf(byteBuf);
        int bodyIndex = byteBuf.writerIndex();
        if (this.credential != null) {
            this.credential.toByteBuf(byteBuf);
        }
        int finalIndex = byteBuf.writerIndex();
        int totalLength = finalIndex - headerIndex;
        int bodyLength = bodyIndex - headerIndex - 24;
        byteBuf.writerIndex(beginIndex + 16);
        byteBuf.writeInt(totalLength);
        byteBuf.writerIndex(beginIndex + 40);
        byteBuf.writeInt(bodyLength);
        byteBuf.writerIndex(finalIndex);
        assert (bodyLength >= 0);
        assert (totalLength >= 0);
    }

    public String prettyPrint() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.format("envHead: 0x%x  sessionId: %d requestId: %d sequenceNumber: %d messageLength: %d", this.envelope.compoundHead, this.envelope.sessionId, this.envelope.requestId, this.envelope.sequenceNumber, this.envelope.messageLength));
        sb.append(String.format("\t\t\t\topCode:%s respCode:%s opFlag:0x%x siteInfoAndRecursionCount: 0x%x expirationTime: %d bodyLength:%d\n", new Object[]{Opcode.fromInt(this.header.opCode), ResponseCode.fromInt(this.header.responseCode), this.header.opFlag, this.header.siteInfoAndRecursionCount, this.header.expirationTime, this.header.bodyLength}));
        return sb.toString();
    }

    public static String byteArrayToHexString(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[byteArray.length * 3];
        for (int j = 0; j < byteArray.length; ++j) {
            int v = byteArray[j] & 0xFF;
            hexChars[j * 3] = hexArray[v >>> 4];
            hexChars[j * 3 + 1] = hexArray[v & 0xF];
            hexChars[j * 3 + 2] = 32;
        }
        return new String(hexChars);
    }

    public static String byteArrayToBinaryString(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (byte single : byteArray) {
            sb.append(Integer.toBinaryString(single));
        }
        return sb.toString();
    }

    public void setSender(InetSocketAddress sender) {
        this.sender = sender;
    }

    public InetSocketAddress getSender() {
        return this.sender;
    }
}

