/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.codec;

import io.netty.buffer.ByteBuf;

public class MessageHeader {
    public int opCode;
    public int responseCode;
    public int opFlag;
    public int siteInfoAndRecursionCount;
    public int expirationTime;
    public int bodyLength;

    public boolean getAuthoritativeFlag() {
        return (this.opFlag & Integer.MIN_VALUE) != 0;
    }

    public boolean getCertifiedFlag() {
        return (this.opFlag & 0x40000000) != 0;
    }

    public boolean getEncryptionFlag() {
        return (this.opFlag & 0x20000000) != 0;
    }

    public boolean getRecursiveFlag() {
        return (this.opFlag & 0x10000000) != 0;
    }

    public boolean getCacheAuthenticationFlag() {
        return (this.opFlag & 0x8000000) != 0;
    }

    public boolean getContinuousFlag() {
        return (this.opFlag & 0x4000000) != 0;
    }

    public boolean getKeepConnectionFlag() {
        return (this.opFlag & 0x2000000) != 0;
    }

    public boolean getPublicOnlyFlag() {
        return (this.opFlag & 0x1000000) != 0;
    }

    public boolean getRequestDigestFlag() {
        return (this.opFlag & 0x800000) != 0;
    }

    public boolean getOverwriteWhenExistsFlag() {
        return (this.opFlag & 0x400000) != 0;
    }

    public boolean getMintNewSuffixFlag() {
        return (this.opFlag & 0x200000) != 0;
    }

    public boolean getDoNotReferFlag() {
        return (this.opFlag & 0x100000) != 0;
    }

    public int getSiteInfoSerialNumber() {
        return (this.siteInfoAndRecursionCount & 0xFFFF0000) >>> 16;
    }

    public byte getRecursionCount() {
        return (byte)((this.siteInfoAndRecursionCount & 0xFF00) >>> 8);
    }

    public static MessageHeader fromByteBuf(ByteBuf byteBuf) {
        MessageHeader header = new MessageHeader();
        header.opCode = byteBuf.readInt();
        header.responseCode = byteBuf.readInt();
        header.opFlag = byteBuf.readInt();
        header.siteInfoAndRecursionCount = byteBuf.readInt();
        header.expirationTime = byteBuf.readInt();
        header.bodyLength = byteBuf.readInt();
        return header;
    }

    public void toByteBuf(ByteBuf byteBuf) {
        byteBuf.writeInt(this.opCode);
        byteBuf.writeInt(this.responseCode);
        byteBuf.writeInt(this.opFlag);
        byteBuf.writeInt(this.siteInfoAndRecursionCount);
        byteBuf.writeInt(this.expirationTime);
        byteBuf.writeInt(this.bodyLength);
    }
}

