/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.server;

import io.netty.bootstrap.AbstractBootstrap;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.bdware.irp.irpserver.IrpListenerInfo;
import org.bdware.irp.irpserver.IrpServerInfo;
import org.bdware.irp3.handler.IrpHandlerBase;
import org.bdware.irp3.handler.ReflectiveRequestHandler;
import org.bdware.irp3.server.BootstrapInitializer;
import org.bdware.irp3.server.BootstrapInitializerFactory;
import org.bdware.irp3.server.IrpListener;

public class IRPServer {
    private final IrpServerInfo serverInfo;
    private final ArrayList<BootstrapInitializer> initializers;
    ReflectiveRequestHandler requestCallback;

    public IRPServer(IrpServerInfo info) {
        this.serverInfo = info;
        this.requestCallback = new ReflectiveRequestHandler();
        this.initializers = new ArrayList();
        for (IrpListenerInfo listenerInfo : info.listenerInfos) {
            BootstrapInitializer<? extends AbstractBootstrap> listener = BootstrapInitializerFactory.createServerBootstrapInitializer(listenerInfo);
            this.initializers.add(listener);
        }
    }

    public void addHandler(IrpHandlerBase handlerBase) {
        this.requestCallback.addHandler(handlerBase);
    }

    public void start() {
        ExecutorService pool = Executors.newFixedThreadPool(this.initializers.size());
        for (final BootstrapInitializer initializer : this.initializers) {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    new IrpListener(IRPServer.this.requestCallback, initializer).start();
                }
            });
        }
    }
}

