/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irpserver;

import io.netty.channel.ChannelHandlerContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp.irplib.core.IrpMessage;
import org.bdware.irp.irplib.core.IrpResponse;
import org.bdware.irp.irpserver.IrpHandler;
import org.bdware.irp.irpserver.IrpRequestHandler;
import org.bdware.irp.irpserver.NettyIrpListener;

public class IrpRequestHandlerImpl
implements IrpRequestHandler {
    static Logger logger = LogManager.getLogger(NettyIrpListener.class);
    IrpHandler irpHandler;

    public void setIrpHandler(IrpHandler irsHandler) {
        this.irpHandler = irsHandler;
    }

    @Override
    public IrpMessage onRequest(ChannelHandlerContext ctx, IrpMessage msg) {
        IrpMessage res;
        int opCode = msg.header.opCode;
        logger.debug("[Call operation] name: " + opCode);
        try {
            switch (opCode) {
                case 1: 
                case 11: 
                case 121: {
                    res = this.irpHandler.resolveDOID(msg);
                    break;
                }
                case 100: 
                case 110: {
                    res = this.irpHandler.createDOID(msg);
                    break;
                }
                case 101: 
                case 111: {
                    res = this.irpHandler.deleteDOID(msg);
                    break;
                }
                case 104: 
                case 117: {
                    res = this.irpHandler.updateDOID(msg);
                    break;
                }
                case 120: {
                    res = this.irpHandler.batchCreateDOID(msg);
                    break;
                }
                case 211: {
                    res = this.irpHandler.verifyIrs(msg);
                    break;
                }
                case 213: {
                    res = this.irpHandler.createPrefix(msg);
                    break;
                }
                case 214: {
                    res = this.irpHandler.updatePrefix(msg);
                    break;
                }
                case 215: {
                    res = this.irpHandler.deletePrefix(msg);
                    break;
                }
                case 212: {
                    res = this.irpHandler.resolvePrefix(msg);
                    break;
                }
                case 800: {
                    res = this.irpHandler.verifyChildRouter(msg);
                    break;
                }
                case 802: {
                    res = this.irpHandler.queryIdentifierByOffset(msg);
                    break;
                }
                default: {
                    logger.debug("Unknown opcode to handler");
                    res = IrpResponse.newErrorResponse(opCode, 2, "Unknown opcode to handler");
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("Unknown opcode to handler", (Throwable)e);
            e.printStackTrace();
            res = IrpResponse.newErrorResponse(opCode, 2, "Unknown opcode to handler");
        }
        return res;
    }
}

